/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei.coffee;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.jei.RecipeWrapperWithButton;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CoffeeMachineRecipeWrapper
extends RecipeWrapperWithButton
implements IRecipeWrapper {
    public final CoffeeIngredient theIngredient;
    public final ItemStack theOutput;
    public final ItemStack cup = new ItemStack(InitItems.itemMisc, 1, TheMiscItems.CUP.ordinal());
    public final ItemStack coffeeBeans = new ItemStack(InitItems.itemCoffeeBean);

    public CoffeeMachineRecipeWrapper(CoffeeIngredient ingredient) {
        this.theIngredient = ingredient;
        this.theOutput = new ItemStack(InitItems.itemCoffee);
        ActuallyAdditionsAPI.methodHandler.addEffectToStack(this.theOutput, this.theIngredient);
    }

    public List getInputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.theIngredient.ingredient);
        list.add(this.cup);
        list.add(this.coffeeBeans);
        return list;
    }

    public List getOutputs() {
        return Collections.singletonList(this.theOutput);
    }

    public List<FluidStack> getFluidInputs() {
        return new ArrayList<FluidStack>();
    }

    public List<FluidStack> getFluidOutputs() {
        return new ArrayList<FluidStack>();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.updateButton(minecraft, mouseX, mouseY);
        if (this.theIngredient.getExtraText() != null) {
            minecraft.field_71466_p.func_175065_a(StringUtil.localize("container.nei.actuallyadditions.coffee.special") + ":", 2.0f, 4.0f, 0x404040, false);
            minecraft.field_71466_p.func_175065_a(this.theIngredient.getExtraText(), 2.0f, 16.0f, 0x404040, false);
        }
        if (this.theIngredient.maxAmplifier > 0) {
            minecraft.field_71466_p.func_175065_a(StringUtil.localize("container.nei.actuallyadditions.coffee.maxAmount") + ": " + this.theIngredient.maxAmplifier, 2.0f, 28.0f, 0x404040, false);
        }
    }

    public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return this.handleClick(minecraft, mouseX, mouseY);
    }

    @Override
    public int getButtonX() {
        return 0;
    }

    @Override
    public int getButtonY() {
        return 70;
    }

    @Override
    public BookletPage getPage() {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockCoffeeMachine));
    }
}

