/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCrafter;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiGrinder;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.jei.booklet.BookletRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.booklet.BookletRecipeHandler;
import de.ellpeck.actuallyadditions.mod.jei.coffee.CoffeeMachineRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.coffee.CoffeeMachineRecipeHandler;
import de.ellpeck.actuallyadditions.mod.jei.crusher.CrusherRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.crusher.CrusherRecipeHandler;
import de.ellpeck.actuallyadditions.mod.jei.empowerer.EmpowererRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.empowerer.EmpowererRecipeHandler;
import de.ellpeck.actuallyadditions.mod.jei.reconstructor.ReconstructorRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.reconstructor.ReconstructorRecipeHandler;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIActuallyAdditionsPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new BookletRecipeCategory(helpers.getGuiHelper()), new CoffeeMachineRecipeCategory(helpers.getGuiHelper()), new CrusherRecipeCategory(helpers.getGuiHelper()), new ReconstructorRecipeCategory(helpers.getGuiHelper()), new EmpowererRecipeCategory(helpers.getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BookletRecipeHandler(), new CoffeeMachineRecipeHandler(), new CrusherRecipeHandler(), new ReconstructorRecipeHandler(), new EmpowererRecipeHandler()});
        registry.addRecipes(ActuallyAdditionsAPI.BOOKLET_PAGES_WITH_ITEM_DATA);
        registry.addRecipes(ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS);
        registry.addRecipes(ActuallyAdditionsAPI.CRUSHER_RECIPES);
        registry.addRecipes(ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES);
        registry.addRecipes(ActuallyAdditionsAPI.EMPOWERER_RECIPES);
        registry.addRecipeClickArea(GuiCoffeeMachine.class, 53, 42, 22, 16, new String[]{"actuallyadditions.coffee"});
        registry.addRecipeClickArea(GuiGrinder.class, 80, 40, 24, 22, new String[]{"actuallyadditions.crushing"});
        registry.addRecipeClickArea(GuiGrinder.GuiGrinderDouble.class, 51, 40, 74, 22, new String[]{"actuallyadditions.crushing"});
        registry.addRecipeClickArea(GuiFurnaceDouble.class, 51, 40, 74, 22, new String[]{"minecraft.smelting"});
        IItemBlacklist blacklist = helpers.getItemBlacklist();
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockRice));
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockCanola));
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockFlax));
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockCoffee));
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockWildPlant, 1, Short.MAX_VALUE));
        blacklist.addItemToBlacklist(new ItemStack(InitBlocks.blockColoredLampOn, 1, Short.MAX_VALUE));
        blacklist.addItemToBlacklist(new ItemStack(InitItems.itemMisc, 1, TheMiscItems.YOUTUBE_ICON.ordinal()));
        IRecipeTransferRegistry transfer = registry.getRecipeTransferRegistry();
        transfer.addRecipeTransferHandler(ContainerCrafter.class, "minecraft.crafting", 1, 9, 10, 36);
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitItems.itemCrafterOnAStick), new String[]{"minecraft.crafting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockFurnaceDouble), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockGrinder), new String[]{"actuallyadditions.crushing"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockGrinderDouble), new String[]{"actuallyadditions.crushing"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockCoffeeMachine), new String[]{"actuallyadditions.coffee"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockAtomicReconstructor), new String[]{"actuallyadditions.reconstructor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitBlocks.blockEmpowerer), new String[]{"actuallyadditions.empowerer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(InitItems.itemBooklet), new String[]{"actuallyadditions.booklet"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

