/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import cofh.api.energy.ItemEnergyContainer;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.ItemTeslaWrapper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemEnergy
extends ItemEnergyContainer {
    private final String name;

    public ItemEnergy(int maxPower, int transfer, String name) {
        super(maxPower, transfer);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.name = name;
        this.register();
    }

    private void register() {
        ItemUtil.registerItem(this, this.getBaseName(), this.shouldAddCreative());
        this.registerRendering();
    }

    protected String getBaseName() {
        return this.name;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    protected void registerRendering() {
        ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Item)this), this.getRegistryName(), "inventory");
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.setEnergy(stack, 0);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + " RF");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack stackFull = new ItemStack((Item)this);
        this.setEnergy(stackFull, this.getMaxEnergyStored(stackFull));
        list.add(stackFull);
        ItemStack stackEmpty = new ItemStack((Item)this);
        this.setEnergy(stackEmpty, 0);
        list.add(stackEmpty);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double maxAmount = this.getMaxEnergyStored(stack);
        double energyDif = maxAmount - (double)this.getEnergyStored(stack);
        return energyDif / maxAmount;
    }

    public void setEnergy(ItemStack stack, int energy) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74768_a("Energy", energy);
        stack.func_77982_d(compound);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return ActuallyAdditions.teslaLoaded ? new ItemTeslaWrapper(stack, this) : null;
    }
}

