/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.items.metalists.ThePotionRings;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotionRing
extends ItemBase
implements IColorProvidingItem,
IDisplayStandItem {
    public static final ThePotionRings[] ALL_RINGS = ThePotionRings.values();
    private final boolean isAdvanced;

    public ItemPotionRing(boolean isAdvanced, String name) {
        super(name);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.isAdvanced = isAdvanced;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_77952_i() >= ALL_RINGS.length ? "actuallyadditions.lolWutHowUDoDis" : this.func_77658_a() + ItemPotionRing.ALL_RINGS[stack.func_77952_i()].name;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        super.func_77663_a(stack, world, player, par4, par5);
        if (!world.field_72995_K && stack.func_77952_i() < ALL_RINGS.length && player instanceof EntityPlayer) {
            EntityPlayer thePlayer;
            ItemStack equippedStack = (thePlayer = (EntityPlayer)player).func_184614_ca();
            this.effectEntity((EntityLivingBase)thePlayer, stack, equippedStack != null && stack == equippedStack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        String standardName = StringUtil.localize(this.func_77658_a() + ".name");
        if (stack.func_77952_i() < ALL_RINGS.length) {
            String effect = StringUtil.localize(ItemPotionRing.ALL_RINGS[stack.func_77952_i()].name);
            return standardName + " " + effect;
        }
        return standardName;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() >= ALL_RINGS.length ? EnumRarity.COMMON : ItemPotionRing.ALL_RINGS[stack.func_77952_i()].rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < ALL_RINGS.length; ++j) {
            list.add(new ItemStack((Item)this, 1, j));
        }
    }

    @Override
    protected void registerRendering() {
        for (int i = 0; i < ALL_RINGS.length; ++i) {
            ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Item)this, 1, i), this.getRegistryName(), "inventory");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return stack.func_77952_i() >= ALL_RINGS.length ? 0xFFFFFF : ItemPotionRing.ALL_RINGS[stack.func_77952_i()].color;
            }
        };
    }

    @Override
    public boolean update(ItemStack stack, TileEntity tile, int elapsedTicks) {
        boolean advanced = ((ItemPotionRing)stack.func_77973_b()).isAdvanced;
        int range = advanced ? 96 : 16;
        List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(tile.func_174877_v().func_177958_n() - range), (double)(tile.func_174877_v().func_177956_o() - range), (double)(tile.func_174877_v().func_177952_p() - range), (double)(tile.func_174877_v().func_177958_n() + range), (double)(tile.func_174877_v().func_177956_o() + range), (double)(tile.func_174877_v().func_177952_p() + range)));
        if (entities != null && !entities.isEmpty()) {
            if (advanced) {
                for (EntityLivingBase entity : entities) {
                    this.effectEntity(entity, stack, true);
                }
                return true;
            }
            Potion potion = Potion.func_188412_a((int)ThePotionRings.values()[stack.func_77952_i()].effectID);
            for (EntityLivingBase entity : entities) {
                if (!entity.func_70644_a(potion)) continue;
                if (Util.RANDOM.nextInt(100) <= 0) {
                    entity.func_184589_d(potion);
                    break;
                }
                this.effectEntity(entity, stack, true);
                return true;
            }
            Collections.shuffle(entities);
            this.effectEntity((EntityLivingBase)entities.get(0), stack, true);
            return true;
        }
        return false;
    }

    @Override
    public int getUsePerTick(ItemStack stack, TileEntity tile, int elapsedTicks) {
        return 325;
    }

    private void effectEntity(EntityLivingBase thePlayer, ItemStack stack, boolean canUseBasic) {
        ThePotionRings effect = ThePotionRings.values()[stack.func_77952_i()];
        Potion potion = Potion.func_188412_a((int)effect.effectID);
        PotionEffect activeEffect = thePlayer.func_70660_b(potion);
        if (!effect.needsWaitBeforeActivating || activeEffect == null || activeEffect.func_76459_b() <= 1) {
            if (!((ItemPotionRing)stack.func_77973_b()).isAdvanced) {
                if (canUseBasic) {
                    thePlayer.func_70690_d(new PotionEffect(potion, effect.activeTime, effect.normalAmplifier, true, false));
                }
            } else {
                thePlayer.func_70690_d(new PotionEffect(potion, effect.activeTime, effect.advancedAmplifier, true, false));
            }
        }
    }
}

