/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLaserWrench
extends ItemBase {
    public ItemLaserWrench(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing par7, float par8, float par9, float par10) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLaserRelay) {
            if (!world.field_72995_K) {
                if (ItemPhantomConnector.getStoredPosition(stack) == null) {
                    ItemPhantomConnector.storeConnection(stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.actuallyadditions.laser.stored.desc", new Object[0]));
                } else {
                    BlockPos savedPos = ItemPhantomConnector.getStoredPosition(stack);
                    if (savedPos != null) {
                        TileEntity savedTile = world.func_175625_s(savedPos);
                        int distanceSq = (int)savedPos.func_177951_i((Vec3i)pos);
                        if (ItemPhantomConnector.getStoredWorld(stack) == world && savedTile instanceof TileEntityLaserRelay && ((TileEntityLaserRelay)savedTile).isItem == ((TileEntityLaserRelay)tile).isItem && distanceSq <= 225 && ActuallyAdditionsAPI.connectionHandler.addConnection(savedPos, pos, world)) {
                            ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                            ((TileEntityLaserRelay)savedTile).sendUpdate();
                            ((TileEntityLaserRelay)tile).sendUpdate();
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.actuallyadditions.laser.connected.desc", new Object[0]));
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.actuallyadditions.laser.cantConnect.desc", new Object[0]));
                            ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                        }
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            PlayerData.PlayerSave save = PlayerData.getDataFromPlayer(player);
            int currMode = save.theCompound.func_74762_e("LaserWrenchMode");
            currMode = currMode + 1 >= WrenchMode.values().length ? 0 : ++currMode;
            save.theCompound.func_74768_a("LaserWrenchMode", currMode);
            if (player instanceof EntityPlayerMP) {
                PacketHandlerHelper.sendPlayerDataToClientPacket(player, save.theCompound, false);
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Mode changed to " + WrenchMode.values()[currMode].name + "!"));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add(StringUtil.localize("tooltip.actuallyadditions.boundTo.desc") + ":");
            list.add("X: " + coords.func_177958_n());
            list.add("Y: " + coords.func_177956_o());
            list.add("Z: " + coords.func_177952_p());
            list.add(TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.clearStorage.desc"));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public static enum WrenchMode {
        ALWAYS_PARTICLES("always show particles"),
        NO_PARTICLES("never show particles"),
        HOLDING_PARTICLES("show particles when holding a Laser Wrench");

        public final String name;

        private WrenchMode(String name) {
            this.name = name;
        }
    }
}

