/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cofh.api.energy.IEnergyContainerItem;
import com.google.common.collect.Multimap;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrill
extends ItemEnergy {
    public static final int HARVEST_LEVEL = 4;
    private static final int ENERGY_USE = 100;

    public ItemDrill(String name) {
        super(500000, 5000, name);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.setHarvestLevel("shovel", 4);
        this.setHarvestLevel("pickaxe", 4);
    }

    public static void loadSlotsFromNBT(ItemStack[] slots, ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            TileEntityInventoryBase.loadSlots(slots, compound);
        }
    }

    public static void writeSlotsToNBT(ItemStack[] slots, ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        TileEntityInventoryBase.saveSlots(slots, compound);
        stack.func_77982_d(compound);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack anEquip;
        int slot;
        ItemStack upgrade = this.getHasUpgradeAsStack(stack, ItemDrillUpgrade.UpgradeType.PLACER);
        if (upgrade != null && (slot = ItemDrillUpgrade.getSlotToPlaceFrom(upgrade)) >= 0 && slot < InventoryPlayer.func_70451_h() && (anEquip = player.field_71071_by.func_70301_a(slot)) != null && anEquip != stack) {
            ItemStack equip = anEquip.func_77946_l();
            if (!world.field_72995_K) {
                try {
                    if (equip.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ) != EnumActionResult.FAIL) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(slot, equip.field_77994_a <= 0 ? null : equip.func_77946_l());
                        }
                        player.field_71069_bz.func_75142_b();
                        return EnumActionResult.SUCCESS;
                    }
                }
                catch (Exception e) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Ouch! That really hurt! You must have done something wrong, don't do that again please!"));
                    ModUtil.LOGGER.error("Player " + player.func_70005_c_() + " who should place a Block using a Drill at " + player.field_70165_t + ", " + player.field_70163_u + ", " + player.field_70161_v + " in World " + world.field_73011_w.getDimension() + " threw an Exception! Don't let that happen again!");
                }
            } else {
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public ItemStack getHasUpgradeAsStack(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return null;
        }
        ItemStack[] slots = new ItemStack[5];
        ItemDrill.loadSlotsFromNBT(slots, stack);
        if (slots != null && slots.length > 0) {
            for (ItemStack slotStack : slots) {
                if (slotStack == null || !(slotStack.func_77973_b() instanceof ItemDrillUpgrade) || ((ItemDrillUpgrade)slotStack.func_77973_b()).type != upgrade) continue;
                return slotStack;
            }
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.DRILL.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            this.extractEnergy(stack, use, false);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        ItemStack[] slots = new ItemStack[5];
        ItemDrill.loadSlotsFromNBT(slots, stack);
        if (slots != null && slots.length > 0) {
            for (ItemStack slotStack : slots) {
                ITeslaProducer cap;
                if (slotStack == null) continue;
                Item item = slotStack.func_77973_b();
                int extracted = 0;
                int maxExtract = this.getMaxEnergyStored(stack) - this.getEnergyStored(stack);
                if (item instanceof IEnergyContainerItem) {
                    extracted = ((IEnergyContainerItem)item).extractEnergy(slotStack, maxExtract, false);
                } else if (ActuallyAdditions.teslaLoaded && slotStack.hasCapability(TeslaUtil.teslaProducer, null) && (cap = (ITeslaProducer)slotStack.getCapability(TeslaUtil.teslaProducer, null)) != null) {
                    extracted = (int)cap.takePower((long)maxExtract, false);
                }
                if (extracted <= 0) continue;
                this.receiveEnergy(stack, extracted, false);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Drill Modifier", this.getEnergyStored(stack) >= 100 ? 8.0 : (double)0.1f, 0));
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool Modifier", -2.5, 0));
        }
        return map;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) ? (this.hasExtraWhitelist(state.func_177230_c()) || state.func_177230_c().getHarvestTool(state) == null || state.func_177230_c().getHarvestTool(state).isEmpty() || this.getToolClasses(stack).contains(state.func_177230_c().getHarvestTool(state)) ? this.getEfficiencyFromUpgrade(stack) : 1.0f) : 0.1f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean toReturn = false;
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
                ItemUtil.addEnchantment(stack, Enchantments.field_185306_r, 1);
            } else if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
                ItemUtil.addEnchantment(stack, Enchantments.field_185308_t, this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II) ? 3 : 1);
            }
            RayTraceResult ray = WorldUtil.getNearestBlockWithDefaultReachDistance(player.field_70170_p, player);
            if (ray != null) {
                int side = ray.field_178784_b.ordinal();
                toReturn = !player.func_70093_af() && this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE) ? this.breakBlocks(stack, 2, player.field_70170_p, side != 0 && side != 1 ? pos.func_177984_a() : pos, side, player) : this.breakBlocks(stack, 1, player.field_70170_p, pos, side, player)) : this.breakBlocks(stack, 0, player.field_70170_p, pos, side, player);
                ItemUtil.removeEnchantment(stack, Enchantments.field_185306_r);
                ItemUtil.removeEnchantment(stack, Enchantments.field_185308_t);
            }
        }
        return toReturn;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Block block = state.func_177230_c();
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) && (this.hasExtraWhitelist(block) || block.func_149688_o(state).func_76229_l() || block == Blocks.field_150431_aC || block == Blocks.field_150433_aE || block == Blocks.field_150343_Z || block == Blocks.field_150484_ah || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA || block == Blocks.field_150475_bE || block == Blocks.field_150340_R || block == Blocks.field_150352_o || block == Blocks.field_150339_S || block == Blocks.field_150366_p || block == Blocks.field_150368_y || block == Blocks.field_150369_x || block == Blocks.field_150450_ax || block == Blocks.field_150439_ay || block.func_149688_o(state) == Material.field_151576_e || block.func_149688_o(state) == Material.field_151573_f || block.func_149688_o(state) == Material.field_151574_g);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("pickaxe");
        hashSet.add("shovel");
        return hashSet;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 4;
    }

    public int getEnergyUsePerBlock(ItemStack stack) {
        int use = 100;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            use += 50;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II)) {
                use += 75;
                if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III)) {
                    use += 175;
                }
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
            use += 100;
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
            use += 40;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II)) {
                use += 80;
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            use += 10;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                use += 30;
            }
        }
        return use;
    }

    public boolean getHasUpgrade(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        return this.getHasUpgradeAsStack(stack, upgrade) != null;
    }

    @Override
    protected void registerRendering() {
        for (int i = 0; i < 16; ++i) {
            String name = this.getRegistryName() + TheColoredLampColors.values()[i].name;
            ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Item)this, 1, i), new ResourceLocation(name), "inventory");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < 16; ++i) {
            this.addDrillStack(list, i);
        }
    }

    private void addDrillStack(List list, int meta) {
        ItemStack stackFull = new ItemStack((Item)this, 1, meta);
        this.setEnergy(stackFull, this.getMaxEnergyStored(stackFull));
        list.add(stackFull);
        ItemStack stackEmpty = new ItemStack((Item)this, 1, meta);
        this.setEnergy(stackEmpty, 0);
        list.add(stackEmpty);
    }

    public float getEfficiencyFromUpgrade(ItemStack stack) {
        float efficiency = 8.0f;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            efficiency = this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III) ? (efficiency += 37.0f) : (efficiency += 25.0f)) : (efficiency += 8.0f);
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            efficiency *= 0.5f;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                efficiency *= 0.35f;
            }
        }
        return efficiency;
    }

    public boolean breakBlocks(ItemStack stack, int radius, World world, BlockPos aPos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(aPos);
        float mainHardness = state.func_185887_b(world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (!this.tryHarvestBlock(world, aPos, false, stack, player, use)) {
                return false;
            }
        } else {
            return false;
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.func_177958_n() - xRange; xPos <= aPos.func_177958_n() + xRange; ++xPos) {
                for (int yPos = aPos.func_177956_o() - yRange; yPos <= aPos.func_177956_o() + yRange; ++yPos) {
                    for (int zPos = aPos.func_177952_p() - zRange; zPos <= aPos.func_177952_p() + zRange; ++zPos) {
                        if (aPos.func_177958_n() == xPos && aPos.func_177956_o() == yPos && aPos.func_177952_p() == zPos) continue;
                        if (this.getEnergyStored(stack) >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            IBlockState theState = world.func_180495_p(thePos);
                            if (!(theState.func_185887_b(world, thePos) <= mainHardness + 5.0f)) continue;
                            this.tryHarvestBlock(world, thePos, true, stack, player, use);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean tryHarvestBlock(World world, BlockPos pos, boolean isExtra, ItemStack stack, EntityPlayer player, int use) {
        boolean canHarvest;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float hardness = block.func_176195_g(state, world, pos);
        boolean bl = canHarvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || isExtra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !block.hasTileEntity(world.func_180495_p(pos)))) {
            this.extractEnergy(stack, use, false);
            return WorldUtil.playerHarvestBlock(stack, world, player, pos);
        }
        return false;
    }

    private boolean hasExtraWhitelist(Block block) {
        String name;
        ResourceLocation location;
        if (block != null && (location = block.getRegistryName()) != null && (name = location.toString()) != null) {
            for (String s : ConfigStringListValues.DRILL_EXTRA_MINING_WHITELIST.getValue()) {
                if (s == null || !s.equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

