/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class EnergyDisplay
extends Gui {
    private EnergyStorage rfReference;
    private int x;
    private int y;
    private boolean outline;
    private boolean drawTextNextTo;
    private boolean displayTesla;

    public EnergyDisplay(int x, int y, EnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.setData(x, y, rfReference, outline, drawTextNextTo);
    }

    public EnergyDisplay(int x, int y, EnergyStorage rfReference) {
        this(x, y, rfReference, false, false);
    }

    public void setData(int x, int y, EnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.x = x;
        this.y = y;
        this.rfReference = rfReference;
        this.outline = outline;
        this.drawTextNextTo = drawTextNextTo;
        this.displayTesla = PlayerData.getDataFromPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).theCompound.func_74767_n("DisplayTesla");
    }

    public void draw() {
        int vOffset;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(AssetUtil.GUI_INVENTORY_LOCATION);
        int barX = this.x;
        int barY = this.y;
        int n = vOffset = this.displayTesla ? 85 : 0;
        if (this.outline) {
            this.func_73729_b(this.x, this.y, 52, 163, 26, 93);
            barX += 4;
            barY += 4;
        }
        this.func_73729_b(barX, barY, 18, 171 - vOffset, 18, 85);
        if (this.rfReference.getEnergyStored() > 0) {
            int i = this.rfReference.getEnergyStored() * 83 / this.rfReference.getMaxEnergyStored();
            this.func_73729_b(barX + 1, barY + 84 - i, 36, 172 - vOffset, 16, i);
        }
        if (this.drawTextNextTo) {
            this.func_73731_b(mc.field_71466_p, this.getOverlayText(), barX + 25, barY + 78, 0xFFFFFF);
        }
    }

    public void drawOverlay(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Minecraft mc = Minecraft.func_71410_x();
            ArrayList<String> text = new ArrayList<String>();
            text.add(this.getOverlayText());
            text.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + StringUtil.localize("info.actuallyadditions.energy.to" + (this.displayTesla ? "RF" : "T")));
            GuiUtils.drawHoveringText(text, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }

    public void onMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.changeDisplayMode();
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + (this.outline ? 26 : 18) && mouseY < this.y + (this.outline ? 93 : 85);
    }

    private String getOverlayText() {
        return this.rfReference.getEnergyStored() + "/" + this.rfReference.getMaxEnergyStored() + (this.displayTesla ? " T" : " RF");
    }

    private void changeDisplayMode() {
        NBTTagCompound data = new NBTTagCompound();
        this.displayTesla = !this.displayTesla;
        data.func_74757_a("DisplayTesla", this.displayTesla);
        PacketHandlerHelper.sendChangePlayerDataPacket(data);
    }
}

