/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenLushCaves
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        this.generateCave(world, position, rand);
        return true;
    }

    private void generateCave(World world, BlockPos center, Random rand) {
        int spheres = rand.nextInt(5) + 3;
        for (int i = 0; i <= spheres; ++i) {
            this.makeSphereWithGrassFloor(world, center.func_177982_a(rand.nextInt(11) - 5, rand.nextInt(7) - 3, rand.nextInt(11) - 5), rand.nextInt(3) + 5);
        }
        this.genTreesAndTallGrass(world, center, 10, spheres * 3, rand);
    }

    private void genTreesAndTallGrass(World world, BlockPos center, int radius, int amount, Random rand) {
        ArrayList<BlockPos> possiblePoses = new ArrayList<BlockPos>();
        for (double x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double y = (double)(-radius); y < (double)radius; y += 1.0) {
                for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                    BlockPos pos;
                    if (!(rand.nextDouble() >= 0.5) || world.func_180495_p(pos = center.func_177963_a(x, y, z)).func_177230_c() != Blocks.field_150349_c) continue;
                    possiblePoses.add(pos);
                }
            }
        }
        if (!possiblePoses.isEmpty()) {
            for (int i = 0; i <= amount; ++i) {
                Collections.shuffle(possiblePoses);
                BlockPos pos = (BlockPos)possiblePoses.get(0);
                if (rand.nextBoolean()) {
                    WorldGenTrees trees = rand.nextBoolean() ? (rand.nextBoolean() ? new WorldGenBigTree(false) : new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P())) : new WorldGenTrees(false);
                    trees.func_180709_b(world, rand, pos.func_177984_a());
                    continue;
                }
                Blocks.field_150349_c.func_176474_b(world, rand, pos, world.func_180495_p(pos));
            }
        }
    }

    private void makeSphereWithGrassFloor(World world, BlockPos center, int radius) {
        double x;
        for (x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double y = (double)(-radius); y < (double)radius; y += 1.0) {
                for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                    if (!(Math.sqrt(x * x + y * y + z * z) < (double)radius)) continue;
                    world.func_175698_g(center.func_177963_a(x, y, z));
                }
            }
        }
        for (x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                for (double y = (double)(-radius); y <= -3.0; y += 1.0) {
                    BlockPos pos = center.func_177963_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    BlockPos posUp = pos.func_177984_a();
                    IBlockState stateUp = world.func_180495_p(posUp);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || !stateUp.func_177230_c().isAir(stateUp, (IBlockAccess)world, posUp)) continue;
                    world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }
}

