/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import com.google.common.base.Predicate;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheWildPlants;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntListValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.gen.WorldGenLushCaves;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class OreGen
implements IWorldGenerator {
    public static final int QUARTZ_MIN = 0;
    public static final int QUARTZ_MAX = 45;
    private final WorldGenLushCaves caveGen = new WorldGenLushCaves();

    public OreGen() {
        ModUtil.LOGGER.info("Registering World Generator...");
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)10);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimension = world.field_73011_w.getDimension();
        if (dimension != -1 && dimension != 1 && world.func_175624_G() != WorldType.field_77138_c && !ArrayUtils.contains((int[])ConfigIntListValues.ORE_GEN_DIMENSION_BLACKLIST.getValue(), (int)world.field_73011_w.getDimension())) {
            this.generateDefault(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateDefault(World world, Random random, int x, int z) {
        if (ConfigBoolValues.GENERATE_QUARTZ.isEnabled()) {
            this.addOreSpawn(InitBlocks.blockMisc, TheMiscBlocks.ORE_QUARTZ.ordinal(), Blocks.field_150348_b, world, random, x, z, MathHelper.func_76136_a((Random)random, (int)5, (int)8), 10, 0, 45);
        }
        if (ConfigBoolValues.GEN_LUSH_CAVES.isEnabled() && random.nextInt(ConfigIntValues.LUSH_CAVE_CHANCE.getValue()) <= 0) {
            BlockPos posAtHeight = world.func_175672_r(new BlockPos(x + random.nextInt(16) + 8, 0, z + random.nextInt(16) + 8));
            this.caveGen.func_180709_b(world, random, posAtHeight.func_177979_c(MathHelper.func_76136_a((Random)random, (int)10, (int)(posAtHeight.func_177956_o() - 10))));
        }
    }

    public void addOreSpawn(Block block, int meta, Block blockIn, World world, Random random, int blockXPos, int blockZPos, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        if (maxY > minY) {
            int yDiff = maxY - minY;
            for (int i = 0; i < chancesToSpawn; ++i) {
                int posX = blockXPos + random.nextInt(16);
                int posY = minY + random.nextInt(yDiff);
                int posZ = blockZPos + random.nextInt(16);
                new WorldGenMinable(block.func_176203_a(meta), maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)blockIn)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
            }
        } else {
            ModUtil.LOGGER.fatal("Couldn't generate '" + block.func_149739_a() + "' into the world because the Min Y coordinate is bigger than the Max! This is definitely a Config Error! Check the Files!");
        }
    }

    @SubscribeEvent
    public void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) {
            if (!ArrayUtils.contains((int[])ConfigIntListValues.PLANT_DIMENSION_BLACKLIST.getValue(), (int)event.getWorld().field_73011_w.getDimension())) {
                this.generateRice((DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.CANOLA.ordinal(), ConfigIntValues.CANOLA_AMOUNT.getValue(), ConfigBoolValues.DO_CANOLA_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.FLAX.ordinal(), ConfigIntValues.FLAX_AMOUNT.getValue(), ConfigBoolValues.DO_FLAX_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.COFFEE.ordinal(), ConfigIntValues.COFFEE_AMOUNT.getValue(), ConfigBoolValues.DO_COFFEE_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockBlackLotus, 0, ConfigIntValues.BLACK_LOTUS_AMOUNT.getValue(), ConfigBoolValues.DO_LOTUS_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
            }
            if (ConfigBoolValues.DO_TREASURE_CHEST_GEN.isEnabled() && event.getRand().nextInt(300) == 0) {
                BlockPos randomPos = new BlockPos(event.getPos().func_177958_n() + event.getRand().nextInt(16) + 8, 0, event.getPos().func_177952_p() + event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180494_b(randomPos) instanceof BiomeOcean && randomPos.func_177956_o() >= 25 && randomPos.func_177956_o() <= 45 && event.getWorld().func_180495_p(randomPos).func_185904_a() == Material.field_151586_h && event.getWorld().func_180495_p(randomPos.func_177977_b()).func_185904_a().func_76220_a()) {
                    event.getWorld().func_180501_a(randomPos, InitBlocks.blockTreasureChest.func_176203_a(event.getRand().nextInt(4)), 2);
                }
            }
        }
    }

    private void generateRice(DecorateBiomeEvent event) {
        if (ConfigBoolValues.DO_RICE_GEN.isEnabled()) {
            for (int i = 0; i < ConfigIntValues.RICE_AMOUNT.getValue(); ++i) {
                if (event.getRand().nextInt(50) != 0) continue;
                BlockPos randomPos = new BlockPos(event.getPos().func_177958_n() + event.getRand().nextInt(16) + 8, 0, event.getPos().func_177952_p() + event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180495_p(randomPos).func_185904_a() != Material.field_151586_h) continue;
                ArrayList<Material> blocksAroundBottom = WorldUtil.getMaterialsAround(event.getWorld(), randomPos);
                BlockPos posToGenAt = randomPos.func_177984_a();
                ArrayList<Material> blocksAroundTop = WorldUtil.getMaterialsAround(event.getWorld(), posToGenAt);
                if (!blocksAroundBottom.contains(Material.field_151577_b) && !blocksAroundBottom.contains(Material.field_151578_c) && !blocksAroundBottom.contains(Material.field_151576_e) && !blocksAroundBottom.contains(Material.field_151595_p) || blocksAroundTop.contains(Material.field_151586_h) || event.getWorld().func_180495_p(posToGenAt).func_185904_a() != Material.field_151579_a) continue;
                event.getWorld().func_180501_a(posToGenAt, InitBlocks.blockWildPlant.func_176203_a(TheWildPlants.RICE.ordinal()), 2);
            }
        }
    }

    private void genPlantNormally(Block plant, int meta, int amount, boolean doIt, Material blockBelow, DecorateBiomeEvent event) {
        if (doIt) {
            for (int i = 0; i < amount; ++i) {
                if (event.getRand().nextInt(400) != 0) continue;
                BlockPos randomPos = new BlockPos(event.getPos().func_177958_n() + event.getRand().nextInt(16) + 8, 0, event.getPos().func_177952_p() + event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180495_p(randomPos.func_177977_b()).func_185904_a() != blockBelow || !plant.func_176196_c(event.getWorld(), randomPos) || !event.getWorld().func_175623_d(randomPos)) continue;
                event.getWorld().func_180501_a(randomPos, plant.func_176203_a(meta), 2);
            }
        }
    }
}

