/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ClientEvents {
    private static final String ADVANCED_INFO_TEXT_PRE = TextFormatting.DARK_GRAY + "     ";
    private static final String ADVANCED_INFO_HEADER_PRE = TextFormatting.GRAY + "  -";
    private static EnergyDisplay energyDisplay;

    public ClientEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack() != null && event.getItemStack().func_77973_b() != null && ConfigBoolValues.CTRL_EXTRA_INFO.isEnabled()) {
            if (GuiScreen.func_146271_m()) {
                NBTTagCompound compound;
                event.getToolTip().add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.extraInfo.desc") + ":");
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)event.getItemStack());
                event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.oredictName.desc") + ":");
                if (oreIDs.length > 0) {
                    for (int oreID : oreIDs) {
                        event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + OreDictionary.getOreName((int)oreID));
                    }
                } else {
                    event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + StringUtil.localize("tooltip.actuallyadditions.noOredictNameAvail.desc"));
                }
                event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.codeName.desc") + ":");
                event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + Item.field_150901_e.func_177774_c((Object)event.getItemStack().func_77973_b()));
                String baseName = event.getItemStack().func_77973_b().func_77658_a();
                if (baseName != null) {
                    event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.baseUnlocName.desc") + ":");
                    event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + baseName);
                }
                int meta = event.getItemStack().func_77952_i();
                int max = event.getItemStack().func_77958_k();
                event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.meta.desc") + ":");
                event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + meta + (max > 0 ? "/" + max : ""));
                String metaName = event.getItemStack().func_77973_b().func_77667_c(event.getItemStack());
                if (metaName != null && baseName != null && !metaName.equals(baseName)) {
                    event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.unlocName.desc") + ":");
                    event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + metaName);
                }
                if ((compound = event.getItemStack().func_77978_p()) != null && !compound.func_82582_d()) {
                    event.getToolTip().add(ADVANCED_INFO_HEADER_PRE + StringUtil.localize("tooltip.actuallyadditions.nbt.desc") + ":");
                    if (GuiScreen.func_146272_n()) {
                        int limit = ConfigIntValues.CTRL_INFO_NBT_CHAR_LIMIT.getValue();
                        String compoundStrg = compound.toString();
                        int compoundStrgLength = compoundStrg.length();
                        String compoundDisplay = limit > 0 && compoundStrgLength > limit ? compoundStrg.substring(0, limit) + TextFormatting.GRAY + " (" + (compoundStrgLength - limit) + " more characters...)" : compoundStrg;
                        event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + compoundDisplay);
                    } else {
                        event.getToolTip().add(ADVANCED_INFO_TEXT_PRE + TextFormatting.ITALIC + "[" + StringUtil.localize("tooltip.actuallyadditions.pressShift.desc") + "]");
                    }
                }
                event.getToolTip().add(TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.disablingInfo.desc"));
            } else if (ConfigBoolValues.CTRL_INFO_FOR_EXTRA_INFO.isEnabled()) {
                event.getToolTip().add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.ctrlForMoreInfo.desc"));
            }
        }
    }

    @SubscribeEvent
    public void onGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && Minecraft.func_71410_x().field_71462_r == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            RayTraceResult posHit = minecraft.field_71476_x;
            FontRenderer font = minecraft.field_71466_p;
            ItemStack stack = player.func_184614_ca();
            if (stack != null && stack.func_77973_b() instanceof IHudDisplay) {
                ((IHudDisplay)stack.func_77973_b()).displayHud(minecraft, (EntityPlayer)player, stack, posHit, event.getResolution());
            }
            if (posHit != null && posHit.func_178782_a() != null) {
                IEnergyDisplay display;
                TileEntityBase base;
                Block blockHit = minecraft.field_71441_e.func_180495_p(posHit.func_178782_a()).func_177230_c();
                TileEntity tileHit = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
                if (blockHit instanceof IHudDisplay) {
                    ((IHudDisplay)blockHit).displayHud(minecraft, (EntityPlayer)player, stack, posHit, event.getResolution());
                }
                if (tileHit instanceof TileEntityBase && (base = (TileEntityBase)tileHit).isRedstoneToggle()) {
                    String strg = "Redstone Mode: " + TextFormatting.DARK_RED + (base.isPulseMode ? "Pulse" : "Deactivation") + TextFormatting.RESET;
                    font.func_175063_a(strg, (float)(event.getResolution().func_78326_a() / 2 + 5), (float)(event.getResolution().func_78328_b() / 2 + 5), 0xFFFFFF);
                    if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockRedstoneTorch) {
                        String expl = TextFormatting.GREEN + "Right-Click to toggle!";
                        font.func_175063_a(expl, (float)(event.getResolution().func_78326_a() / 2 + 5), (float)(event.getResolution().func_78328_b() / 2 + 15), 0xFFFFFF);
                    }
                }
                if (tileHit instanceof IEnergyDisplay && (!(display = (IEnergyDisplay)tileHit).needsHoldShift() || player.func_70093_af())) {
                    if (energyDisplay == null) {
                        energyDisplay = new EnergyDisplay(0, 0, null);
                    }
                    energyDisplay.setData(2, event.getResolution().func_78328_b() - 96, display.getEnergyStorage(), true, true);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    energyDisplay.draw();
                    GlStateManager.func_179121_F();
                }
            }
        }
    }
}

