/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.misc.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.WorldSpecificSaveHandler;

public class WorldData {
    public static final String DATA_TAG = "actuallyadditionsdata";
    private static final ConcurrentHashMap<Integer, WorldData> WORLD_DATA = new ConcurrentHashMap();
    public final ConcurrentSet<Network> laserRelayNetworks = new ConcurrentSet();
    public final ArrayList<PlayerData.PlayerSave> playerSaveData = new ArrayList();
    private final ISaveHandler handler;
    private final int dimension;

    public WorldData(ISaveHandler handler, int dimension) {
        this.handler = handler;
        this.dimension = dimension;
    }

    public static WorldData getWorldUnspecificData() {
        return WorldData.getDataForWorld(DimensionType.OVERWORLD.func_186068_a());
    }

    public static WorldData getDataForWorld(World world) {
        return WorldData.getDataForWorld(world.field_73011_w.getDimension());
    }

    public static WorldData getDataForWorld(int dim) {
        WorldData data = WORLD_DATA.get(dim);
        if (data == null) {
            data = new WorldData(null, dim);
            WORLD_DATA.put(dim, data);
        }
        return data;
    }

    public static void load(World world) {
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldData data = new WorldData((ISaveHandler)new WorldSpecificSaveHandler((WorldServer)world, world.func_72860_G()), world.field_73011_w.getDimension());
            WORLD_DATA.put(data.dimension, data);
            try {
                File dataFile = data.handler.func_75758_b(DATA_TAG + data.dimension);
                if (dataFile != null && dataFile.exists()) {
                    FileInputStream stream = new FileInputStream(dataFile);
                    NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)stream);
                    stream.close();
                    data.readFromNBT(compound);
                    ModUtil.LOGGER.info("Successfully received WorldData for world " + data.dimension + "!");
                } else {
                    ModUtil.LOGGER.info("No WorldData found for world " + data.dimension + ", creating...");
                }
            }
            catch (Exception e) {
                ModUtil.LOGGER.error("Something went wrong trying to load WorldData for world " + data.dimension + "!", (Throwable)e);
            }
        }
    }

    public static void save(World world) {
        if (!world.field_72995_K) {
            WorldData data = WORLD_DATA.get(world.field_73011_w.getDimension());
            if (data != null && data.handler != null) {
                try {
                    File dataFile = data.handler.func_75758_b(DATA_TAG + data.dimension);
                    if (dataFile != null) {
                        if (!dataFile.exists()) {
                            dataFile.createNewFile();
                            ModUtil.LOGGER.info("Creating new WorldData file for world " + data.dimension + "!");
                        }
                        NBTTagCompound compound = new NBTTagCompound();
                        data.writeToNBT(compound);
                        FileOutputStream stream = new FileOutputStream(dataFile);
                        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)stream);
                        stream.close();
                    }
                }
                catch (Exception e) {
                    ModUtil.LOGGER.error("Something went wrong trying to save WorldData for world " + data.dimension + "!", (Throwable)e);
                }
            } else {
                ModUtil.LOGGER.error("Tried to save WorldData for " + world.field_73011_w.getDimension() + " without any data handler being present!?");
            }
        }
    }

    public static void unload(World world) {
        if (!world.field_72995_K) {
            WORLD_DATA.remove(world.field_73011_w.getDimension());
            ModUtil.LOGGER.info("Unloading WorldData for world " + world.field_73011_w.getDimension() + "!");
        }
    }

    private void readFromNBT(NBTTagCompound compound) {
        this.laserRelayNetworks.clear();
        NBTTagList networkList = compound.func_150295_c("Networks", 10);
        for (int i = 0; i < networkList.func_74745_c(); ++i) {
            Network network = LaserRelayConnectionHandler.readNetworkFromNBT(networkList.func_150305_b(i));
            this.laserRelayNetworks.add((Object)network);
        }
        this.playerSaveData.clear();
        NBTTagList playerList = compound.func_150295_c("PlayerData", 10);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            PlayerData.PlayerSave aSave = PlayerData.PlayerSave.fromNBT(playerList.func_150305_b(i));
            this.playerSaveData.add(aSave);
        }
    }

    private void writeToNBT(NBTTagCompound compound) {
        NBTTagList networkList = new NBTTagList();
        for (Network network : this.laserRelayNetworks) {
            networkList.func_74742_a((NBTBase)LaserRelayConnectionHandler.writeNetworkToNBT(network));
        }
        compound.func_74782_a("Networks", (NBTBase)networkList);
        NBTTagList playerList = new NBTTagList();
        for (PlayerData.PlayerSave theSave : this.playerSaveData) {
            playerList.func_74742_a((NBTBase)theSave.toNBT());
        }
        compound.func_74782_a("PlayerData", (NBTBase)playerList);
    }
}

