/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.mod.data.WorldData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class PlayerData {
    public static PlayerSave getDataFromPlayer(UUID id) {
        ArrayList<PlayerSave> data = WorldData.getWorldUnspecificData().playerSaveData;
        for (PlayerSave save : data) {
            if (save.theId == null || !save.theId.equals(id)) continue;
            return save;
        }
        PlayerSave aSave = new PlayerSave(id, new NBTTagCompound());
        data.add(aSave);
        return aSave;
    }

    public static PlayerSave getDataFromPlayer(EntityPlayer player) {
        return PlayerData.getDataFromPlayer(player.func_110124_au());
    }

    public static class PlayerSave {
        public final UUID theId;
        public NBTTagCompound theCompound;

        public PlayerSave(UUID theId, NBTTagCompound theCompound) {
            this.theId = theId;
            this.theCompound = theCompound;
        }

        public static PlayerSave fromNBT(NBTTagCompound compound) {
            UUID theID = new UUID(compound.func_74763_f("MostSignificant"), compound.func_74763_f("LeastSignificant"));
            NBTTagCompound theCompound = compound.func_74775_l("Tag");
            return new PlayerSave(theID, theCompound);
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a("LeastSignificant", this.theId.getLeastSignificantBits());
            compound.func_74772_a("MostSignificant", this.theId.getMostSignificantBits());
            compound.func_74782_a("Tag", (NBTBase)this.theCompound);
            return compound;
        }
    }
}

