/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.internal.IBookletGui;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPageAA;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.RecipeUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageReconstructor
extends BookletPageAA {
    private final LensConversionRecipe[] recipes;
    private int recipePos;

    public PageReconstructor(int id, ArrayList<LensConversionRecipe> recipes) {
        this(id, recipes.toArray(new LensConversionRecipe[recipes.size()]));
    }

    public PageReconstructor(int id, LensConversionRecipe ... recipes) {
        super(id);
        this.recipes = recipes;
        this.addToPagesWithItemStackData();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPre(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (this.recipes[this.recipePos] != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
            gui.drawRect(gui.getGuiLeft() + 37, gui.getGuiTop() + 20, 188, 154, 60, 60);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        LensConversionRecipe recipe = this.recipes[this.recipePos];
        if (recipe == null) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, TextFormatting.DARK_RED + StringUtil.localize("booklet.actuallyadditions.recipeDisabled"), gui.getGuiLeft() + 14, gui.getGuiTop() + 15, 115, 0, false);
        } else {
            String strg = "Atomic Reconstructor";
            Minecraft.func_71410_x().field_71466_p.func_78276_b(strg, gui.getGuiLeft() + gui.getXSize() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(strg) / 2, gui.getGuiTop() + 10, 0);
        }
        String text = gui.getCurrentEntrySet().getCurrentPage().getText();
        if (text != null && !text.isEmpty()) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, text, gui.getGuiLeft() + 14, gui.getGuiTop() + 100, 115, 0, false);
        }
        if (recipe != null) {
            AssetUtil.renderStackToGui(new ItemStack(InitBlocks.blockAtomicReconstructor), gui.getGuiLeft() + 37 + 22, gui.getGuiTop() + 20 + 21, 1.0f);
            for (int i = 0; i < 2; ++i) {
                for (int x = 0; x < 2; ++x) {
                    List<ItemStack> stacks;
                    List<ItemStack> list = stacks = x == 0 ? RecipeUtil.getConversionLensInputs(recipe) : RecipeUtil.getConversionLensOutputs(recipe);
                    if (stacks == null || stacks.isEmpty()) continue;
                    ItemStack stack = stacks.get(0);
                    if (stack.func_77952_i() == Short.MAX_VALUE) {
                        stack.func_77964_b(0);
                    }
                    boolean tooltip = i == 1;
                    int xShow = gui.getGuiLeft() + 37 + 1 + x * 42;
                    int yShow = gui.getGuiTop() + 20 + 21;
                    if (!tooltip) {
                        AssetUtil.renderStackToGui(stack, xShow, yShow, 1.0f);
                        continue;
                    }
                    if (mouseX < xShow || mouseX > xShow + 16 || mouseY < yShow || mouseY > yShow + 16) continue;
                    gui.renderTooltipAndTransferButton(this, stack, mouseX, mouseY, x == 0, mousePressed);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen(int ticksElapsed) {
        if (ticksElapsed % 15 == 0) {
            this.recipePos = this.recipePos + 1 >= this.recipes.length ? 0 : ++this.recipePos;
        }
    }

    @Override
    public ItemStack[] getItemStacksForPage() {
        if (this.recipes != null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (LensConversionRecipe recipe : this.recipes) {
                if (recipe == null) continue;
                stacks.addAll(RecipeUtil.getConversionLensOutputs(recipe));
            }
            return stacks.toArray(new ItemStack[stacks.size()]);
        }
        return null;
    }
}

