/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.internal.IBookletGui;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPageAA;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageFurnace
extends BookletPageAA {
    private final ItemStack result;
    private final ItemStack input;

    public PageFurnace(int id, ItemStack result) {
        this(id, null, result);
    }

    public PageFurnace(int id, ItemStack input, ItemStack result) {
        super(id);
        this.result = result;
        this.input = input;
        this.addToPagesWithItemStackData();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPre(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (this.input != null || this.getInputForOutput(this.result) != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
            gui.drawRect(gui.getGuiLeft() + 37, gui.getGuiTop() + 20, 0, 180, 60, 60);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        ItemStack input;
        ItemStack itemStack = input = this.input != null ? this.input : this.getInputForOutput(this.result);
        if (input == null) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, TextFormatting.DARK_RED + StringUtil.localize("booklet.actuallyadditions.recipeDisabled"), gui.getGuiLeft() + 14, gui.getGuiTop() + 15, 115, 0, false);
        } else {
            String strg = "Furnace Recipe";
            Minecraft.func_71410_x().field_71466_p.func_78276_b(strg, gui.getGuiLeft() + gui.getXSize() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(strg) / 2, gui.getGuiTop() + 10, 0);
        }
        String text = gui.getCurrentEntrySet().getCurrentPage().getText();
        if (text != null && !text.isEmpty()) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, text, gui.getGuiLeft() + 14, gui.getGuiTop() + 100, 115, 0, false);
        }
        if (input != null) {
            for (int i = 0; i < 2; ++i) {
                for (int x = 0; x < 2; ++x) {
                    ItemStack stack;
                    ItemStack itemStack2 = stack = x == 0 ? input : this.result;
                    if (stack.func_77952_i() == Short.MAX_VALUE) {
                        stack.func_77964_b(0);
                    }
                    boolean tooltip = i == 1;
                    int xShow = gui.getGuiLeft() + 37 + 1 + x * 42;
                    int yShow = gui.getGuiTop() + 20 + 21;
                    if (!tooltip) {
                        AssetUtil.renderStackToGui(stack, xShow, yShow, 1.0f);
                        continue;
                    }
                    if (mouseX < xShow || mouseX > xShow + 16 || mouseY < yShow || mouseY > yShow + 16) continue;
                    gui.renderTooltipAndTransferButton(this, stack, mouseX, mouseY, x == 0, mousePressed);
                }
            }
        }
    }

    @Override
    public ItemStack[] getItemStacksForPage() {
        ItemStack[] itemStackArray;
        if (this.result == null) {
            itemStackArray = new ItemStack[]{};
        } else {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = this.result;
        }
        return itemStackArray;
    }

    private ItemStack getInputForOutput(ItemStack output) {
        for (Map.Entry o : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            ItemStack stack = (ItemStack)o.getValue();
            if (!stack.func_77969_a(output)) continue;
            return (ItemStack)o.getKey();
        }
        return null;
    }
}

