/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.internal.IBookletGui;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPageAA;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.RecipeUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageCrusherRecipe
extends BookletPageAA {
    public final CrusherRecipe recipe;
    private int recipePos;

    public PageCrusherRecipe(int id, CrusherRecipe recipe) {
        super(id);
        this.recipe = recipe;
        this.addToPagesWithItemStackData();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPre(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (this.recipe != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
            gui.drawRect(gui.getGuiLeft() + 37, gui.getGuiTop() + 20, 60, 180, 60, 60);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (this.recipe == null) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, TextFormatting.DARK_RED + StringUtil.localize("booklet.actuallyadditions.recipeDisabled"), gui.getGuiLeft() + 14, gui.getGuiTop() + 15, 115, 0, false);
        } else {
            String strg = "Crusher Recipe";
            Minecraft.func_71410_x().field_71466_p.func_78276_b(strg, gui.getGuiLeft() + gui.getXSize() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(strg) / 2, gui.getGuiTop() + 10, 0);
        }
        String text = gui.getCurrentEntrySet().getCurrentPage().getText();
        if (text != null && !text.isEmpty()) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, text, gui.getGuiLeft() + 14, gui.getGuiTop() + 100, 115, 0, false);
        }
        if (this.recipe != null) {
            List<ItemStack> outputOnes;
            if (this.recipe.outputTwoChance > 0) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(this.recipe.outputTwoChance + "%", gui.getGuiLeft() + 37 + 62, gui.getGuiTop() + 20 + 33, 0);
            }
            if ((outputOnes = RecipeUtil.getCrusherRecipeOutputOnes(this.recipe)) != null) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        ItemStack stack;
                        switch (j) {
                            case 0: {
                                List<ItemStack> inputs = RecipeUtil.getCrusherRecipeInputs(this.recipe);
                                stack = inputs.get(Math.min(inputs.size() - 1, this.recipePos));
                                break;
                            }
                            case 1: {
                                stack = outputOnes.get(Math.min(outputOnes.size() - 1, this.recipePos));
                                break;
                            }
                            default: {
                                List<ItemStack> outputTwos = RecipeUtil.getCrusherRecipeOutputTwos(this.recipe);
                                ItemStack itemStack = stack = outputTwos == null ? null : outputTwos.get(Math.min(outputTwos.size() - 1, this.recipePos));
                            }
                        }
                        if (stack == null) continue;
                        if (stack.func_77952_i() == Short.MAX_VALUE) {
                            stack.func_77964_b(0);
                        }
                        boolean tooltip = i == 1;
                        int xShow = gui.getGuiLeft() + 37 + (j == 0 ? 1 : (j == 1 ? 43 : (j == 2 ? 43 : 0)));
                        int yShow = gui.getGuiTop() + 20 + (j == 0 ? 21 : (j == 1 ? 11 : (j == 2 ? 29 : 0)));
                        if (!tooltip) {
                            AssetUtil.renderStackToGui(stack, xShow, yShow, 1.0f);
                            continue;
                        }
                        if (mouseX < xShow || mouseX > xShow + 16 || mouseY < yShow || mouseY > yShow + 16) continue;
                        gui.renderTooltipAndTransferButton(this, stack, mouseX, mouseY, j == 0, mousePressed);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen(int ticksElapsed) {
        if (ticksElapsed % 10 == 0) {
            List<ItemStack> outputTwos = RecipeUtil.getCrusherRecipeOutputTwos(this.recipe);
            this.recipePos = this.recipePos + 1 >= Math.max(RecipeUtil.getCrusherRecipeInputs(this.recipe).size(), Math.max(RecipeUtil.getCrusherRecipeOutputOnes(this.recipe).size(), outputTwos == null ? 0 : outputTwos.size())) ? 0 : ++this.recipePos;
        }
    }

    @Override
    public ItemStack[] getItemStacksForPage() {
        List<ItemStack> outputOnes = RecipeUtil.getCrusherRecipeOutputOnes(this.recipe);
        return this.recipe == null ? new ItemStack[]{} : outputOnes.toArray(new ItemStack[outputOnes.size()]);
    }
}

