/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.internal.IBookletGui;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPageAA;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageCrafting
extends BookletPageAA {
    private final IRecipe[] recipes;
    private int recipePos;

    public PageCrafting(int id, ArrayList<IRecipe> recipes) {
        this(id, recipes.toArray(new IRecipe[recipes.size()]));
    }

    public PageCrafting(int id, IRecipe ... recipes) {
        super(id);
        this.recipes = recipes;
        this.addToPagesWithItemStackData();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPre(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (this.recipes[this.recipePos] != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
            gui.drawRect(gui.getGuiLeft() + 27, gui.getGuiTop() + 20, 146, 20, 99, 60);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBookletGui gui, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        IRecipe recipe = this.recipes[this.recipePos];
        if (recipe == null) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, TextFormatting.DARK_RED + StringUtil.localize("booklet.actuallyadditions.recipeDisabled"), gui.getGuiLeft() + 14, gui.getGuiTop() + 15, 115, 0, false);
        } else {
            String strg = StringUtil.localize("booklet.actuallyadditions." + (recipe instanceof ShapedRecipes ? "shapedRecipe" : (recipe instanceof ShapelessRecipes ? "shapelessRecipe" : (recipe instanceof ShapelessOreRecipe ? "shapelessOreRecipe" : "shapedOreRecipe"))));
            Minecraft.func_71410_x().field_71466_p.func_78276_b(strg, gui.getGuiLeft() + gui.getXSize() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(strg) / 2, gui.getGuiTop() + 10, 0);
        }
        String text = gui.getCurrentEntrySet().getCurrentPage().getText();
        if (text != null && !text.isEmpty()) {
            StringUtil.drawSplitString(Minecraft.func_71410_x().field_71466_p, text, gui.getGuiLeft() + 14, gui.getGuiTop() + 90, 115, 0, false);
        }
        if (recipe != null) {
            ItemStack stack;
            Object input;
            ShapelessRecipes shapeless;
            ItemStack stack2;
            int i;
            ShapedRecipes shaped;
            ItemStack[] stacks = new ItemStack[9];
            int width = 3;
            int height = 3;
            if (recipe instanceof ShapedRecipes) {
                shaped = (ShapedRecipes)recipe;
                width = shaped.field_77576_b;
                height = shaped.field_77577_c;
                for (i = 0; i < shaped.field_77574_d.length; ++i) {
                    stack2 = shaped.field_77574_d[i];
                    if (stack2 == null) continue;
                    stacks[i] = stack2.func_77946_l();
                }
            } else if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                for (i = 0; i < shapeless.field_77579_b.size(); ++i) {
                    stack2 = (ItemStack)shapeless.field_77579_b.get(i);
                    if (stack2 == null) continue;
                    stacks[i] = stack2.func_77946_l();
                }
            } else if (recipe instanceof ShapedOreRecipe) {
                shaped = (ShapedOreRecipe)recipe;
                try {
                    width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)4);
                    height = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)5);
                }
                catch (Exception e) {
                    ModUtil.LOGGER.error("Something went wrong trying to get the Crafting Recipe in the booklet to display!", (Throwable)e);
                }
                for (i = 0; i < shaped.getInput().length; ++i) {
                    input = shaped.getInput()[i];
                    if (input == null) continue;
                    Object object = input instanceof ItemStack ? (ItemStack)input : (stack = ((List)input).isEmpty() ? null : (ItemStack)((List)input).get(0));
                    if (stack == null) continue;
                    stacks[i] = stack.func_77946_l();
                }
            } else if (recipe instanceof ShapelessOreRecipe) {
                shapeless = (ShapelessOreRecipe)recipe;
                for (i = 0; i < shapeless.getInput().size(); ++i) {
                    input = shapeless.getInput().get(i);
                    Object object = input instanceof ItemStack ? (ItemStack)input : (stack = ((List)input).isEmpty() ? null : (ItemStack)((List)input).get(0));
                    if (stack == null) continue;
                    stacks[i] = stack.func_77946_l();
                }
            }
            int xShowOutput = gui.getGuiLeft() + 27 + 82;
            int yShowOutput = gui.getGuiTop() + 20 + 22;
            AssetUtil.renderStackToGui(recipe.func_77571_b(), xShowOutput, yShowOutput, 1.0f);
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean tooltip = i2 == 1;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        ItemStack stack3 = stacks[y * width + x];
                        if (stack3 == null) continue;
                        stack3.field_77994_a = 1;
                        if (stack3.func_77952_i() == Short.MAX_VALUE) {
                            stack3.func_77964_b(0);
                        }
                        int xShow = gui.getGuiLeft() + 27 + 4 + x * 18;
                        int yShow = gui.getGuiTop() + 20 + 4 + y * 18;
                        if (!tooltip) {
                            AssetUtil.renderStackToGui(stack3, xShow, yShow, 1.0f);
                            continue;
                        }
                        if (mouseX < xShow || mouseX > xShow + 16 || mouseY < yShow || mouseY > yShow + 16) continue;
                        gui.renderTooltipAndTransferButton(this, stack3, mouseX, mouseY, true, mousePressed);
                    }
                }
            }
            if (mouseX >= xShowOutput && mouseX <= xShowOutput + 16 && mouseY >= yShowOutput && mouseY <= yShowOutput + 16) {
                gui.renderTooltipAndTransferButton(this, recipe.func_77571_b(), mouseX, mouseY, false, mousePressed);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen(int ticksElapsed) {
        if (ticksElapsed % 15 == 0) {
            this.recipePos = this.recipePos + 1 >= this.recipes.length ? 0 : ++this.recipePos;
        }
    }

    @Override
    public ItemStack[] getItemStacksForPage() {
        if (this.recipes != null) {
            ItemStack[] stacks = new ItemStack[this.recipes.length];
            for (int i = 0; i < this.recipes.length; ++i) {
                ItemStack output;
                if (this.recipes[i] == null || (output = this.recipes[i].func_77571_b()) == null) continue;
                if (!this.arePageStacksWildcard) {
                    stacks[i] = output;
                    continue;
                }
                ItemStack wildcardOutput = output.func_77946_l();
                wildcardOutput.func_77964_b(Short.MAX_VALUE);
                stacks[i] = wildcardOutput;
            }
            return stacks;
        }
        return null;
    }
}

