/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.entry;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.internal.IEntrySet;
import net.minecraft.nbt.NBTTagCompound;

public class EntrySet
implements IEntrySet {
    private BookletPage page;
    private IBookletChapter chapter;
    private IBookletEntry entry;
    private int pageInIndex;

    public EntrySet(IBookletEntry entry) {
        this(null, null, entry, 1);
    }

    public EntrySet(BookletPage page, IBookletChapter chapter, IBookletEntry entry, int pageInIndex) {
        this.setEntry(page, chapter, entry, pageInIndex);
    }

    public static EntrySet readFromNBT(NBTTagCompound compound) {
        String entryName;
        if (compound != null && !(entryName = compound.func_74779_i("Entry")).isEmpty()) {
            for (IBookletEntry entry : ActuallyAdditionsAPI.BOOKLET_ENTRIES) {
                if (!entryName.equals(entry.getIdentifier())) continue;
                int indexPage = compound.func_74762_e("PageInIndex");
                String chapterName = compound.func_74779_i("Chapter");
                if (!chapterName.isEmpty()) {
                    for (IBookletChapter chapter : entry.getChapters()) {
                        if (!chapterName.equals(chapter.getIdentifier())) continue;
                        int page = compound.func_74762_e("Page");
                        if (page == -1) break;
                        return new EntrySet(chapter.getPageById(page), chapter, entry, indexPage);
                    }
                }
                return new EntrySet(null, null, entry, indexPage);
            }
        }
        return new EntrySet(null);
    }

    @Override
    public void setEntry(BookletPage page, IBookletChapter chapter, IBookletEntry entry, int pageInIndex) {
        this.page = page;
        this.chapter = chapter;
        this.entry = entry;
        this.pageInIndex = pageInIndex;
    }

    @Override
    public void removeEntry() {
        this.setEntry(null, null, null, 1);
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("PageInIndex", this.pageInIndex);
        compound.func_74778_a("Entry", this.entry != null ? this.entry.getIdentifier() : "");
        compound.func_74778_a("Chapter", this.chapter != null ? this.chapter.getIdentifier() : "");
        compound.func_74768_a("Page", this.page != null ? this.page.getChapter().getPageId(this.page) : -1);
        return compound;
    }

    @Override
    public BookletPage getCurrentPage() {
        return this.page;
    }

    @Override
    public IBookletEntry getCurrentEntry() {
        return this.entry;
    }

    @Override
    public IBookletChapter getCurrentChapter() {
        return this.chapter;
    }

    @Override
    public int getPageInIndex() {
        return this.pageInIndex;
    }

    @Override
    public void setPage(BookletPage page) {
        this.page = page;
    }

    @Override
    public void setEntry(IBookletEntry entry) {
        this.entry = entry;
    }

    @Override
    public void setChapter(IBookletChapter chapter) {
        this.chapter = chapter;
    }

    @Override
    public void setPageInIndex(int page) {
        this.pageInIndex = page;
    }
}

