/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.chapter;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class BookletChapter
implements IBookletChapter {
    public final BookletPage[] pages;
    public final IBookletEntry entry;
    public final ItemStack displayStack;
    private final String identifier;
    public TextFormatting color;

    public BookletChapter(String identifier, IBookletEntry entry, ItemStack displayStack, BookletPage ... pages) {
        this.pages = (BookletPage[])pages.clone();
        this.identifier = identifier;
        entry.addChapter(this);
        ActuallyAdditionsAPI.allAndSearch.addChapter(this);
        this.entry = entry;
        this.displayStack = displayStack;
        for (BookletPage page : this.pages) {
            page.setChapter(this);
        }
        this.color = TextFormatting.RESET;
    }

    @Override
    public BookletPage[] getPages() {
        return this.pages;
    }

    @Override
    public BookletPage getPageById(int id) {
        return this.getPages()[id - 1];
    }

    @Override
    public int getPageId(BookletPage page) {
        return ArrayUtils.indexOf((Object[])this.getPages(), (Object)page) + 1;
    }

    @Override
    public String getLocalizedName() {
        return StringUtil.localize("booklet.actuallyadditions.chapter." + this.getIdentifier() + ".name");
    }

    @Override
    public String getLocalizedNameWithFormatting() {
        return this.color + this.getLocalizedName();
    }

    @Override
    public IBookletEntry getEntry() {
        return this.entry;
    }

    @Override
    public ItemStack getDisplayItemStack() {
        return this.displayStack;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setImportant() {
        this.color = TextFormatting.DARK_GREEN;
    }

    public void setSpecial() {
        this.color = TextFormatting.DARK_PURPLE;
    }
}

