/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.internal.IBookletGui;
import de.ellpeck.actuallyadditions.api.internal.IEntrySet;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.booklet.GuiAAAchievements;
import de.ellpeck.actuallyadditions.mod.booklet.InitBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.button.BookmarkButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.IndexButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.TexturedButton;
import de.ellpeck.actuallyadditions.mod.booklet.entry.BookletEntryAllSearch;
import de.ellpeck.actuallyadditions.mod.booklet.entry.EntrySet;
import de.ellpeck.actuallyadditions.mod.config.GuiConfiguration;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.items.ItemBooklet;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiBooklet
extends GuiScreen
implements IBookletGui {
    public static final ResourceLocation RES_LOC = AssetUtil.getBookletGuiLocation("guiBooklet");
    public static final ResourceLocation RES_LOC_ADDON = AssetUtil.getBookletGuiLocation("guiBookletAddon");
    public static final int CHAPTER_BUTTONS_AMOUNT = 13;
    public static final int INDEX_BUTTONS_OFFSET = 3;
    private static final int[] AND_HIS_NAME_IS = new int[]{46, 18, 49, 30};
    public final int xSize;
    public final int ySize;
    public final IEntrySet currentEntrySet = new EntrySet(null);
    public final GuiButton[] chapterButtons = new GuiButton[13];
    public final GuiButton[] bookmarkButtons = new GuiButton[8];
    public final GuiScreen parentScreen;
    private final boolean tryOpenMainPage;
    private final boolean saveOnClose;
    public int guiLeft;
    public int guiTop;
    public int indexPageAmount;
    public GuiButton buttonForward;
    public GuiButton buttonBackward;
    public GuiButton buttonPreviousScreen;
    public GuiButton buttonUpdate;
    public GuiButton buttonTwitter;
    public GuiButton buttonForum;
    public GuiButton buttonAchievements;
    public GuiButton buttonConfig;
    public GuiButton buttonWebsite;
    public GuiButton buttonPatreon;
    public GuiButton buttonViewOnline;
    public GuiTextField searchField;
    public boolean shouldSaveDataNextClose;
    public String bookletName;
    private int ticksElapsed;
    private boolean mousePressed;
    private int hisNameIsAt;

    public GuiBooklet(GuiScreen parentScreen, boolean tryOpenMainPage, boolean saveOnClose) {
        this.xSize = 146;
        this.ySize = 180;
        this.parentScreen = parentScreen;
        this.tryOpenMainPage = tryOpenMainPage;
        this.saveOnClose = saveOnClose;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public List getButtonList() {
        return this.field_146292_n;
    }

    public void func_73863_a(int x, int y, float f) {
        boolean unicodeBefore = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(RES_LOC);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.currentEntrySet.getCurrentEntry() instanceof BookletEntryAllSearch && this.currentEntrySet.getCurrentChapter() == null) {
            this.func_73729_b(this.guiLeft + 146, this.guiTop + 160, 146, 80, 70, 14);
        }
        BookletUtils.drawAchievementInfo(this, true, x, y);
        this.field_146289_q.func_78264_a(false);
        BookletUtils.drawTitle(this);
        this.field_146289_q.func_78264_a(true);
        BookletUtils.renderPre(this, x, y, this.ticksElapsed, this.mousePressed);
        if (this.currentEntrySet.getCurrentPage() != null) {
            this.field_146289_q.func_78264_a(false);
        }
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, x, y);
        }
        this.field_146289_q.func_78264_a(true);
        this.searchField.func_146194_f();
        if (this.currentEntrySet.getCurrentEntry() != null && this.currentEntrySet.getCurrentChapter() != null && this.currentEntrySet.getCurrentPage() != null) {
            this.currentEntrySet.getCurrentPage().render(this, x, y, this.ticksElapsed, this.mousePressed);
        }
        this.field_146289_q.func_78264_a(false);
        BookletUtils.doHoverTexts(this, x, y);
        BookletUtils.drawAchievementInfo(this, false, x, y);
        this.field_146289_q.func_78264_a(unicodeBefore);
        this.mousePressed = false;
    }

    public void func_73869_a(char theChar, int key) {
        if (!this.searchField.func_146206_l() && AND_HIS_NAME_IS.length > this.hisNameIsAt && AND_HIS_NAME_IS[this.hisNameIsAt] == key) {
            if (this.hisNameIsAt + 1 >= AND_HIS_NAME_IS.length) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundHandler.duhDuhDuhDuuuh, (float)0.5f));
                ModUtil.LOGGER.info("AND HIS NAME IS JOHN CENA DUH DUH DUH DUUUH");
                this.hisNameIsAt = 0;
            } else {
                ++this.hisNameIsAt;
            }
        } else {
            this.hisNameIsAt = 0;
            if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && !this.searchField.func_146206_l()) {
                if (this.parentScreen != null) {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                } else {
                    this.field_146297_k.func_147108_a(null);
                    this.field_146297_k.func_71381_h();
                }
            } else if (this.searchField.func_146206_l()) {
                this.searchField.func_146201_a(theChar, key);
                BookletUtils.updateSearchBar(this);
            }
        }
    }

    public void func_146283_a(List list, int x, int y) {
        super.func_146283_a(list, x, y);
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        this.searchField.func_146192_a(par1, par2, par3);
        if (par3 == 0 && this.currentEntrySet.getCurrentChapter() != null) {
            this.mousePressed = true;
        } else if (par3 == 1) {
            if (this.currentEntrySet.getCurrentChapter() != null) {
                BookletUtils.openIndexEntry(this, this.currentEntrySet.getCurrentEntry(), this.currentEntrySet.getPageInIndex(), true);
            } else {
                BookletUtils.openIndexEntry(this, null, 1, true);
            }
        }
        super.func_73864_a(par1, par2, par3);
    }

    public void func_146284_a(GuiButton button) {
        if (this.currentEntrySet.getCurrentPage() != null && this.currentEntrySet.getCurrentPage().onActionPerformed(this, button)) {
            return;
        }
        if (button == this.buttonUpdate) {
            if (UpdateChecker.needsUpdateNotify) {
                BookletUtils.openBrowser("http://ellpeck.de/actaddchangelog", "http://ellpeck.de/actadddownload");
            }
        } else if (button == this.buttonViewOnline) {
            IBookletChapter chapter = this.currentEntrySet.getCurrentChapter();
            if (chapter != null) {
                BookletUtils.openBrowser("http://ellpeck.de/actaddmanual/#" + chapter.getIdentifier());
            }
        } else if (button == this.buttonWebsite) {
            BookletUtils.openBrowser("http://ellpeck.de");
        } else if (button == this.buttonPatreon) {
            BookletUtils.openBrowser("http://www.patreon.com/Ellpeck");
        } else if (button == this.buttonTwitter) {
            BookletUtils.openBrowser("http://twitter.com/ActAddMod");
        } else if (button == this.buttonForum) {
            BookletUtils.openBrowser("http://ellpeck.de/actadd");
        } else if (button == this.buttonConfig) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfiguration(this));
        } else if (button == this.buttonAchievements) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiAAAchievements(this, this.field_146297_k.field_71439_g.func_146107_m()));
        } else if (button == this.buttonForward) {
            BookletUtils.handleNextPage(this);
        } else if (button == this.buttonBackward) {
            BookletUtils.handlePreviousPage(this);
        } else if (button == this.buttonPreviousScreen) {
            if (this.currentEntrySet.getCurrentChapter() != null) {
                BookletUtils.openIndexEntry(this, this.currentEntrySet.getCurrentEntry(), this.currentEntrySet.getPageInIndex(), true);
            } else {
                BookletUtils.openIndexEntry(this, null, 1, true);
            }
        } else if (button instanceof BookmarkButton) {
            ((BookmarkButton)button).onPressed();
        } else {
            BookletUtils.handleChapterButtonClick(this, button);
        }
    }

    public void func_73866_w_() {
        int i;
        int flavor = 1;
        if ((double)Util.RANDOM.nextFloat() <= 0.1) {
            flavor = MathHelper.func_76136_a((Random)Util.RANDOM, (int)2, (int)6);
        }
        this.bookletName = "info.actuallyadditions.booklet.manualName.1." + flavor;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonForward = new TexturedButton(0, this.guiLeft + this.xSize - 26, this.guiTop + this.ySize + 1, 164, 0, 18, 10, Collections.singletonList(TextFormatting.GOLD + "Next Page"));
        this.field_146292_n.add(this.buttonForward);
        this.buttonBackward = new TexturedButton(1, this.guiLeft + 8, this.guiTop + this.ySize + 1, 146, 0, 18, 10, Collections.singletonList(TextFormatting.GOLD + "Previous Page"));
        this.field_146292_n.add(this.buttonBackward);
        this.buttonPreviousScreen = new TexturedButton(2, this.guiLeft + this.xSize / 2 - 7, this.guiTop + this.ySize + 1, 182, 0, 15, 10, Collections.singletonList(TextFormatting.GOLD + "Back"));
        this.field_146292_n.add(this.buttonPreviousScreen);
        ArrayList<String> updateHover = new ArrayList<String>();
        if (UpdateChecker.checkFailed) {
            updateHover.add(ITextComponent.Serializer.func_150699_a((String)StringUtil.localize("info.actuallyadditions.update.failed")).func_150254_d());
        } else if (UpdateChecker.needsUpdateNotify) {
            updateHover.add(ITextComponent.Serializer.func_150699_a((String)StringUtil.localize("info.actuallyadditions.update.generic")).func_150254_d());
            updateHover.add(ITextComponent.Serializer.func_150699_a((String)StringUtil.localizeFormatted("info.actuallyadditions.update.versionCompare", "1.10.2-r60", UpdateChecker.updateVersionString)).func_150254_d());
            updateHover.add(StringUtil.localize("info.actuallyadditions.update.buttonOptions"));
        }
        this.buttonUpdate = new TexturedButton(4, this.guiLeft - 11, this.guiTop - 11, 245, 0, 11, 11, updateHover);
        this.buttonUpdate.field_146125_m = UpdateChecker.needsUpdateNotify || UpdateChecker.checkFailed;
        this.field_146292_n.add(this.buttonUpdate);
        this.buttonTwitter = new TexturedButton(5, this.guiLeft, this.guiTop + 10, 213, 0, 8, 8, Collections.singletonList(TextFormatting.GOLD + "Open @ActAddMod on Twitter in Browser"));
        this.field_146292_n.add(this.buttonTwitter);
        this.buttonForum = new TexturedButton(6, this.guiLeft, this.guiTop + 20, 221, 0, 8, 8, Collections.singletonList(TextFormatting.GOLD + "Open CurseForge Page in Browser"));
        this.field_146292_n.add(this.buttonForum);
        this.buttonAchievements = new TexturedButton(7, this.guiLeft + 138, this.guiTop, 205, 0, 8, 8, Collections.singletonList(TextFormatting.GOLD + "Show Achievements"));
        this.field_146292_n.add(this.buttonAchievements);
        ArrayList<String> websiteHover = new ArrayList<String>();
        websiteHover.add(TextFormatting.GOLD + "Open Author's Website");
        websiteHover.add("(There's some cool stuff there!)");
        websiteHover.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + "Would you call this Product Placement?");
        this.buttonWebsite = new TexturedButton(-99, this.guiLeft, this.guiTop + 30, 229, 0, 8, 8, websiteHover);
        this.field_146292_n.add(this.buttonWebsite);
        ArrayList<String> patreonHover = new ArrayList<String>();
        patreonHover.add("Like the mod?");
        patreonHover.add("Why don't support me on " + TextFormatting.GOLD + "Patreon" + TextFormatting.RESET + "?");
        this.buttonPatreon = new TexturedButton(-100, this.guiLeft, this.guiTop, 237, 0, 8, 8, patreonHover);
        this.field_146292_n.add(this.buttonPatreon);
        this.buttonViewOnline = new TexturedButton(-101, this.guiLeft + 146, this.guiTop + 180, 245, 44, 11, 11, Collections.singletonList(TextFormatting.GOLD + "View Online"));
        this.field_146292_n.add(this.buttonViewOnline);
        ArrayList<String> configHover = new ArrayList<String>();
        configHover.add(TextFormatting.GOLD + "Show Configuration GUI");
        configHover.addAll(this.field_146289_q.func_78271_c("It is highly recommended that you restart your game after changing anything as that prevents possible bugs occuring!", 200));
        this.buttonConfig = new TexturedButton(8, this.guiLeft + 138, this.guiTop + 10, 197, 0, 8, 8, configHover);
        this.field_146292_n.add(this.buttonConfig);
        for (i = 0; i < this.chapterButtons.length; ++i) {
            this.chapterButtons[i] = new IndexButton(9 + i, this.guiLeft + 15, this.guiTop + 10 + i * 12, 115, 10, "", this);
            this.field_146292_n.add(this.chapterButtons[i]);
        }
        for (i = 0; i < this.bookmarkButtons.length; ++i) {
            int x = this.guiLeft + this.xSize / 2 - this.bookmarkButtons.length / 2 * 16 + i * 16;
            this.bookmarkButtons[i] = new BookmarkButton(this.chapterButtons[this.chapterButtons.length - 1].field_146127_k + 1 + i, x, this.guiTop + this.ySize + 13, this);
            this.field_146292_n.add(this.bookmarkButtons[i]);
        }
        this.searchField = new GuiTextField(4500, this.field_146289_q, this.guiLeft + 148, this.guiTop + 162, 66, 10);
        this.searchField.func_146203_f(30);
        this.searchField.func_146185_a(false);
        this.searchField.func_146205_d(false);
        this.currentEntrySet.removeEntry();
        if (ItemBooklet.forcedEntry == null) {
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (data != null) {
                if (this.tryOpenMainPage && !data.theCompound.func_74767_n("BookAlreadyOpened")) {
                    BookletUtils.openIndexEntry(this, InitBooklet.chapterIntro.entry, 1, true);
                    BookletUtils.openChapter(this, InitBooklet.chapterIntro, null);
                    NBTTagCompound extraData = new NBTTagCompound();
                    extraData.func_74757_a("BookAlreadyOpened", true);
                    PacketHandlerHelper.sendChangePlayerDataPacket(extraData);
                } else {
                    BookletUtils.openLastBookPage(this, data.theCompound.func_74775_l("BookletData"));
                }
            }
            this.shouldSaveDataNextClose = false;
        } else {
            BookletUtils.openIndexEntry(this, ItemBooklet.forcedEntry.getCurrentEntry(), ItemBooklet.forcedEntry.getPageInIndex(), true);
            BookletUtils.openChapter(this, ItemBooklet.forcedEntry.getCurrentChapter(), ItemBooklet.forcedEntry.getCurrentPage());
            ItemBooklet.forcedEntry = null;
            this.shouldSaveDataNextClose = true;
        }
    }

    public void func_146274_d() throws IOException {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            if (wheel < 0) {
                BookletUtils.handleNextPage(this);
            } else if (wheel > 0) {
                BookletUtils.handlePreviousPage(this);
            }
        }
        super.func_146274_d();
    }

    public void func_73876_c() {
        boolean buttonThere;
        super.func_73876_c();
        this.searchField.func_146178_a();
        if (this.currentEntrySet.getCurrentEntry() != null && this.currentEntrySet.getCurrentChapter() != null && this.currentEntrySet.getCurrentPage() != null) {
            this.currentEntrySet.getCurrentPage().updateScreen(this.ticksElapsed);
        }
        this.buttonUpdate.field_146125_m = buttonThere = UpdateChecker.needsUpdateNotify || UpdateChecker.checkFailed;
        if (buttonThere && this.ticksElapsed % 8 == 0) {
            TexturedButton button = (TexturedButton)this.buttonUpdate;
            button.setTexturePos(245, button.texturePosY == 0 ? 22 : 0);
        }
        ++this.ticksElapsed;
    }

    public void func_146281_b() {
        if (this.saveOnClose && this.shouldSaveDataNextClose) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && mc.field_71439_g != null) {
                NBTTagCompound bookletData = new NBTTagCompound();
                BookletUtils.saveBookPage(this, bookletData);
                NBTTagCompound extraData = new NBTTagCompound();
                extraData.func_74782_a("BookletData", (NBTBase)bookletData);
                PacketHandlerHelper.sendChangePlayerDataPacket(extraData);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void renderTooltipAndTransferButton(BookletPage from, ItemStack stack, int x, int y, boolean renderTransferButton, boolean mousePressed) {
        BookletPage page;
        boolean flagBefore = this.field_146297_k.field_71466_p.func_82883_a();
        this.field_146297_k.field_71466_p.func_78264_a(false);
        List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        if (renderTransferButton && (page = BookletUtils.getFirstPageForStack(stack)) != null && page != from) {
            list.add(from.getClickToSeeRecipeString());
            if (mousePressed) {
                BookletUtils.openIndexEntry(this, page.getChapter().getEntry(), ActuallyAdditionsAPI.BOOKLET_ENTRIES.indexOf(page.getChapter().getEntry()) / 13 + 1, true);
                BookletUtils.openChapter(this, page.getChapter(), page);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }
        this.func_146283_a(list, x, y);
        this.field_146297_k.field_71466_p.func_78264_a(flagBefore);
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public void drawRect(int startX, int startY, int u, int v, int xSize, int ySize) {
        this.func_73729_b(startX, startY, u, v, xSize, ySize);
    }

    @Override
    public IEntrySet getCurrentEntrySet() {
        return this.currentEntrySet;
    }
}

