/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.mod.achievement.TheAchievements;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.button.BookmarkButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.IndexButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.TexturedButton;
import de.ellpeck.actuallyadditions.mod.booklet.entry.BookletEntryAllSearch;
import de.ellpeck.actuallyadditions.mod.booklet.entry.EntrySet;
import de.ellpeck.actuallyadditions.mod.proxy.ClientProxy;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public final class BookletUtils {
    @SideOnly(value=Side.CLIENT)
    public static void openBrowser(String url) {
        BookletUtils.openBrowser(url, url);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openBrowser(String url, String shiftUrl) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (shiftUrl.equals(url) || GuiScreen.func_146272_n()) {
                    Desktop.getDesktop().browse(new URI(shiftUrl));
                } else {
                    Desktop.getDesktop().browse(new URI(url));
                }
            }
        }
        catch (Exception e) {
            ModUtil.LOGGER.error("Something bad happened when trying to open a URL!", (Throwable)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTitle(GuiBooklet booklet) {
        String strg;
        booklet.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
        booklet.func_73729_b(booklet.guiLeft + booklet.xSize / 2 - 71, booklet.guiTop - 12, 0, 240, 142, 12);
        booklet.func_73729_b(booklet.guiLeft + booklet.xSize / 2 - 71, booklet.guiTop + booklet.ySize, 0, 243, 142, 13);
        if (booklet.currentEntrySet.getCurrentEntry() == null) {
            strg = TextFormatting.DARK_GREEN + StringUtil.localize(booklet.bookletName);
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 12, 0);
            strg = TextFormatting.DARK_GREEN + StringUtil.localize("info.actuallyadditions.booklet.manualName.2");
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 12 + booklet.getFontRenderer().field_78288_b, 0);
            String playerName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
            String version = playerName.equals("dqmhose") ? "Pants Edition" : (playerName.equals("TwoOfEight") ? "Illustrator's Edition" : (playerName.equals("KittyVanCat") ? "Cat's Edition" : (playerName.equals("canitzp") ? "P's Edition" : (playerName.equals("Ellpeck") || Util.isDevVersion() ? "Dev's Edition" : StringUtil.localize("info.actuallyadditions.booklet.edition") + " " + Util.getMajorModVersion()))));
            strg = TextFormatting.GOLD + TextFormatting.ITALIC.toString() + "-" + version + "-";
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 33, 0);
        }
        strg = booklet.currentEntrySet.getCurrentChapter() == null ? (booklet.currentEntrySet.getCurrentEntry() == null ? StringUtil.localize("itemGroup.actuallyadditions") : booklet.currentEntrySet.getCurrentEntry().getLocalizedName()) : booklet.currentEntrySet.getCurrentChapter().getLocalizedName();
        booklet.func_73732_a(booklet.getFontRenderer(), strg, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop - 9, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawAchievementInfo(GuiBooklet booklet, boolean pre, int mouseX, int mouseY) {
        if (booklet.currentEntrySet.getCurrentChapter() == null) {
            return;
        }
        ArrayList<TheAchievements> achievements = null;
        for (BookletPage page : booklet.currentEntrySet.getCurrentChapter().getPages()) {
            if (page == null || page.getItemStacksForPage() == null) continue;
            for (ItemStack stack : page.getItemStacksForPage()) {
                if (stack == null) continue;
                for (TheAchievements achievement : TheAchievements.values()) {
                    if (!ItemUtil.contains(achievement.itemsToBeGotten, stack, true)) continue;
                    if (pre) {
                        booklet.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.RES_LOC);
                        booklet.func_73729_b(booklet.guiLeft + booklet.xSize + 1, booklet.guiTop - 18, 166, 154, 22, 21);
                        return;
                    }
                    if (mouseX < booklet.guiLeft + booklet.xSize + 1 || mouseX >= booklet.guiLeft + booklet.xSize + 1 + 22 || mouseY < booklet.guiTop - 18 || mouseY >= booklet.guiTop - 18 + 21) continue;
                    if (achievements == null) {
                        achievements = new ArrayList<TheAchievements>();
                    }
                    if (achievements.contains((Object)achievement)) continue;
                    achievements.add(achievement);
                }
            }
        }
        if (achievements != null) {
            ArrayList<String> infoList = null;
            for (TheAchievements achievement : achievements) {
                if (infoList == null) {
                    infoList = new ArrayList<String>();
                    infoList.add(TextFormatting.GOLD + "Achievements related to this chapter:");
                }
                infoList.add("-" + StringUtil.localize(achievement.chieve.field_75975_e));
                infoList.add(TextFormatting.GRAY + "(" + achievement.chieve.func_75989_e() + ")");
            }
            if (infoList != null) {
                booklet.func_146283_a(infoList, mouseX, mouseY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderPre(GuiBooklet booklet, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (booklet.currentEntrySet.getCurrentEntry() != null) {
            if (booklet.currentEntrySet.getCurrentChapter() != null && booklet.currentEntrySet.getCurrentPage() != null) {
                booklet.func_73732_a(booklet.getFontRenderer(), booklet.currentEntrySet.getCurrentPage().getID() + "/" + booklet.currentEntrySet.getCurrentChapter().getPages().length, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop + 171, 0xFFFFFF);
                booklet.currentEntrySet.getCurrentPage().renderPre(booklet, mouseX, mouseY, ticksElapsed, mousePressed);
            } else {
                booklet.func_73732_a(booklet.getFontRenderer(), booklet.currentEntrySet.getPageInIndex() + "/" + booklet.indexPageAmount, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop + 171, 0xFFFFFF);
            }
        } else {
            String wordCountString = StringUtil.localizeFormatted("booklet.actuallyadditions.amountOfWords", ClientProxy.bookletWordCount);
            booklet.getFontRenderer().func_78276_b(TextFormatting.ITALIC + wordCountString, booklet.guiLeft + booklet.xSize - booklet.getFontRenderer().func_78256_a(wordCountString) - 15, booklet.guiTop + booklet.ySize - 18 - booklet.getFontRenderer().field_78288_b, 0);
            String charCountString = StringUtil.localizeFormatted("booklet.actuallyadditions.amountOfChars", ClientProxy.bookletCharCount);
            booklet.getFontRenderer().func_78276_b(TextFormatting.ITALIC + charCountString, booklet.guiLeft + booklet.xSize - booklet.getFontRenderer().func_78256_a(charCountString) - 15, booklet.guiTop + booklet.ySize - 18, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doHoverTexts(GuiBooklet booklet, int mouseX, int mouseY) {
        for (Object button : booklet.getButtonList()) {
            if (!(button instanceof GuiButton) || !((GuiButton)button).field_146125_m || !((GuiButton)button).func_146115_a()) continue;
            if (button instanceof BookmarkButton) {
                ((BookmarkButton)((Object)button)).drawHover(mouseX, mouseY);
                continue;
            }
            if (!(button instanceof TexturedButton)) continue;
            booklet.func_146283_a(((TexturedButton)((Object)button)).textList, mouseX, mouseY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateSearchBar(GuiBooklet booklet) {
        if (booklet.currentEntrySet.getCurrentEntry() instanceof BookletEntryAllSearch) {
            BookletEntryAllSearch currentEntry = (BookletEntryAllSearch)booklet.currentEntrySet.getCurrentEntry();
            if (booklet.searchField.func_146179_b() != null && !booklet.searchField.func_146179_b().isEmpty()) {
                currentEntry.chapters.clear();
                for (IBookletChapter chapter : currentEntry.allChapters) {
                    String searchFieldText = booklet.searchField.func_146179_b().toLowerCase(Locale.ROOT);
                    if (!chapter.getLocalizedName().toLowerCase(Locale.ROOT).contains(searchFieldText) && !BookletUtils.getChapterStacksContainString(searchFieldText, chapter)) continue;
                    currentEntry.chapters.add(chapter);
                }
            } else {
                currentEntry.setChapters((ArrayList)currentEntry.allChapters.clone());
            }
            BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.getCurrentEntry(), booklet.currentEntrySet.getPageInIndex(), false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean getChapterStacksContainString(String text, IBookletChapter chapter) {
        Minecraft mc = Minecraft.func_71410_x();
        for (BookletPage page : chapter.getPages()) {
            ItemStack[] pageStacks = page.getItemStacksForPage();
            if (pageStacks == null) continue;
            for (ItemStack stack : pageStacks) {
                if (stack == null || stack.func_77973_b() == null) continue;
                List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                for (String s : list) {
                    if (s == null || s.isEmpty() || !s.toLowerCase(Locale.ROOT).contains(text)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void openIndexEntry(GuiBooklet booklet, IBookletEntry entry, int page, boolean resetTextField) {
        booklet.searchField.func_146189_e(entry instanceof BookletEntryAllSearch);
        booklet.searchField.func_146195_b(entry instanceof BookletEntryAllSearch);
        if (resetTextField) {
            booklet.searchField.func_146180_a("");
            if (entry instanceof BookletEntryAllSearch) {
                entry.setChapters((List)((BookletEntryAllSearch)entry).allChapters.clone());
            }
        }
        if (booklet.currentEntrySet.getCurrentPage() != null) {
            booklet.currentEntrySet.getCurrentPage().onClosed(booklet);
        }
        booklet.currentEntrySet.setPage(null);
        booklet.currentEntrySet.setChapter(null);
        booklet.currentEntrySet.setEntry(entry);
        booklet.indexPageAmount = entry == null ? 1 : entry.getChapters().size() / booklet.chapterButtons.length + 1;
        booklet.currentEntrySet.setPageInIndex(entry == null ? 1 : (booklet.indexPageAmount <= page || page <= 0 ? booklet.indexPageAmount : page));
        booklet.buttonPreviousScreen.field_146125_m = entry != null;
        booklet.buttonForward.field_146125_m = booklet.currentEntrySet.getPageInIndex() < booklet.indexPageAmount;
        booklet.buttonBackward.field_146125_m = booklet.currentEntrySet.getPageInIndex() > 1;
        booklet.buttonViewOnline.field_146125_m = false;
        for (int i = 0; i < booklet.chapterButtons.length; ++i) {
            boolean entryExists;
            IndexButton button = (IndexButton)booklet.chapterButtons[i];
            if (entry == null) {
                if (i >= 3) {
                    button.field_146125_m = entryExists = ActuallyAdditionsAPI.BOOKLET_ENTRIES.size() > i - 3;
                    if (!entryExists) continue;
                    button.field_146126_j = "- " + ActuallyAdditionsAPI.BOOKLET_ENTRIES.get(i - 3).getLocalizedNameWithFormatting();
                    button.chap = null;
                    continue;
                }
                button.field_146125_m = false;
                continue;
            }
            button.field_146125_m = entryExists = entry.getChapters().size() > i + (booklet.chapterButtons.length * booklet.currentEntrySet.getPageInIndex() - booklet.chapterButtons.length);
            if (!entryExists) continue;
            IBookletChapter chap = entry.getChapters().get(i + (booklet.chapterButtons.length * booklet.currentEntrySet.getPageInIndex() - booklet.chapterButtons.length));
            button.field_146126_j = chap.getLocalizedNameWithFormatting();
            button.chap = chap;
        }
        booklet.shouldSaveDataNextClose = true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleChapterButtonClick(GuiBooklet booklet, GuiButton button) {
        int place = ArrayUtils.indexOf((Object[])booklet.chapterButtons, (Object)button);
        if (place >= 0) {
            if (booklet.currentEntrySet.getCurrentEntry() != null) {
                if (booklet.currentEntrySet.getCurrentChapter() == null && place < booklet.currentEntrySet.getCurrentEntry().getChapters().size()) {
                    IBookletChapter chap = booklet.currentEntrySet.getCurrentEntry().getChapters().get(place + (booklet.chapterButtons.length * booklet.currentEntrySet.getPageInIndex() - booklet.chapterButtons.length));
                    BookletUtils.openChapter(booklet, chap, chap.getPages()[0]);
                }
            } else if (place - 3 < ActuallyAdditionsAPI.BOOKLET_ENTRIES.size()) {
                BookletUtils.openIndexEntry(booklet, ActuallyAdditionsAPI.BOOKLET_ENTRIES.get(place - 3), 1, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void openChapter(GuiBooklet booklet, IBookletChapter chapter, BookletPage page) {
        if (chapter == null || booklet.currentEntrySet.getCurrentEntry() == null) {
            return;
        }
        booklet.searchField.func_146189_e(false);
        booklet.searchField.func_146195_b(false);
        booklet.searchField.func_146180_a("");
        booklet.currentEntrySet.setChapter(chapter);
        if (booklet.currentEntrySet.getCurrentPage() != null) {
            booklet.currentEntrySet.getCurrentPage().onClosed(booklet);
        }
        BookletPage pageToSet = page != null && BookletUtils.doesChapterHavePage(chapter, page) ? page : chapter.getPages()[0];
        booklet.currentEntrySet.setPage(pageToSet);
        pageToSet.onOpened(booklet);
        booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(chapter, booklet.currentEntrySet.getCurrentPage()) != null;
        booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(chapter, booklet.currentEntrySet.getCurrentPage()) != null;
        booklet.buttonPreviousScreen.field_146125_m = true;
        booklet.buttonViewOnline.field_146125_m = true;
        for (GuiButton chapterButton : booklet.chapterButtons) {
            chapterButton.field_146125_m = false;
        }
        booklet.shouldSaveDataNextClose = true;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean doesChapterHavePage(IBookletChapter chapter, BookletPage page) {
        for (BookletPage aPage : chapter.getPages()) {
            if (aPage != page) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static BookletPage getNextPage(IBookletChapter chapter, BookletPage page) {
        for (int i = 0; i < chapter.getPages().length; ++i) {
            if (chapter.getPages()[i] != page || i + 1 >= chapter.getPages().length) continue;
            return chapter.getPages()[i + 1];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static BookletPage getPrevPage(IBookletChapter chapter, BookletPage page) {
        for (int i = 0; i < chapter.getPages().length; ++i) {
            if (chapter.getPages()[i] != page || i - 1 < 0) continue;
            return chapter.getPages()[i - 1];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleNextPage(GuiBooklet booklet) {
        if (booklet.currentEntrySet.getCurrentEntry() != null) {
            if (booklet.currentEntrySet.getCurrentPage() != null) {
                BookletPage page = BookletUtils.getNextPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage());
                if (page != null) {
                    booklet.currentEntrySet.getCurrentPage().onClosed(booklet);
                    booklet.currentEntrySet.setPage(page);
                    page.onOpened(booklet);
                }
                booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage()) != null;
                booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage()) != null;
            } else if (booklet.currentEntrySet.getPageInIndex() + 1 <= booklet.indexPageAmount) {
                BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.getCurrentEntry(), booklet.currentEntrySet.getPageInIndex() + 1, !(booklet.currentEntrySet.getCurrentEntry() instanceof BookletEntryAllSearch));
            }
        }
        booklet.shouldSaveDataNextClose = true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handlePreviousPage(GuiBooklet booklet) {
        if (booklet.currentEntrySet.getCurrentEntry() != null) {
            if (booklet.currentEntrySet.getCurrentPage() != null) {
                BookletPage page = BookletUtils.getPrevPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage());
                if (page != null) {
                    booklet.currentEntrySet.getCurrentPage().onClosed(booklet);
                    booklet.currentEntrySet.setPage(page);
                    page.onOpened(booklet);
                }
                booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage()) != null;
                booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(booklet.currentEntrySet.getCurrentChapter(), booklet.currentEntrySet.getCurrentPage()) != null;
            } else if (booklet.currentEntrySet.getPageInIndex() - 1 > 0) {
                BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.getCurrentEntry(), booklet.currentEntrySet.getPageInIndex() - 1, !(booklet.currentEntrySet.getCurrentEntry() instanceof BookletEntryAllSearch));
            }
        }
        booklet.shouldSaveDataNextClose = true;
    }

    public static BookletPage getFirstPageForStack(ItemStack stack) {
        ArrayList<BookletPage> pages = BookletUtils.getPagesForStack(stack);
        return pages.isEmpty() ? null : pages.get(0);
    }

    public static ArrayList<BookletPage> getPagesForStack(ItemStack stack) {
        ArrayList<BookletPage> possiblePages = new ArrayList<BookletPage>();
        for (BookletPage page : ActuallyAdditionsAPI.BOOKLET_PAGES_WITH_ITEM_DATA) {
            if (!ItemUtil.contains(page.getItemStacksForPage(), stack, page.arePageStacksWildcard)) continue;
            possiblePages.add(page);
        }
        return possiblePages;
    }

    @SideOnly(value=Side.CLIENT)
    public static void saveBookPage(GuiBooklet gui, NBTTagCompound compound) {
        compound.func_74782_a("SavedEntry", (NBTBase)gui.currentEntrySet.writeToNBT());
        compound.func_74778_a("SearchWord", gui.searchField.func_146179_b());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < gui.bookmarkButtons.length; ++i) {
            BookmarkButton button = (BookmarkButton)gui.bookmarkButtons[i];
            list.func_74742_a((NBTBase)button.assignedEntry.writeToNBT());
        }
        compound.func_74782_a("Bookmarks", (NBTBase)list);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLastBookPage(GuiBooklet gui, NBTTagCompound compound) {
        EntrySet set = EntrySet.readFromNBT(compound.func_74775_l("SavedEntry"));
        if (set != null) {
            String searchText;
            BookletUtils.openIndexEntry(gui, set.getCurrentEntry(), set.getPageInIndex(), true);
            if (set.getCurrentChapter() != null) {
                BookletUtils.openChapter(gui, set.getCurrentChapter(), set.getCurrentPage());
            }
            if (!(searchText = compound.func_74779_i("SearchWord")).isEmpty()) {
                gui.searchField.func_146180_a(searchText);
                BookletUtils.updateSearchBar(gui);
            }
        } else {
            BookletUtils.openIndexEntry(gui, null, 1, true);
        }
        NBTTagList list = compound.func_150295_c("Bookmarks", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                BookmarkButton button = (BookmarkButton)gui.bookmarkButtons[i];
                button.assignedEntry = EntrySet.readFromNBT(list.func_150305_b(i));
            }
        }
    }
}

