/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class BlockContainerBase
extends BlockContainer
implements ItemBlockBase.ICustomRarity {
    private final String name;

    public BlockContainerBase(Material material, String name) {
        super(material);
        this.name = name;
        this.register();
    }

    private void register() {
        ItemUtil.registerBlock((Block)this, this.getItemBlock(), this.getBaseName(), this.shouldAddCreative());
        this.registerRendering();
    }

    protected String getBaseName() {
        return this.name;
    }

    protected ItemBlockBase getItemBlock() {
        return new ItemBlockBase((Block)this);
    }

    public boolean shouldAddCreative() {
        return true;
    }

    protected void registerRendering() {
        ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Block)this), this.getRegistryName(), "inventory");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public void dropInventory(World world, BlockPos position) {
        TileEntityInventoryBase tile;
        TileEntity aTile;
        if (!world.field_72995_K && (aTile = world.func_175625_s(position)) instanceof TileEntityInventoryBase && (tile = (TileEntityInventoryBase)aTile).func_70302_i_() > 0) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                this.dropSlotFromInventory(i, tile, world, position);
            }
        }
    }

    public void dropSlotFromInventory(int i, TileEntityInventoryBase tile, World world, BlockPos pos) {
        ItemStack stack = tile.func_70301_a(i);
        if (stack != null && stack.field_77994_a > 0) {
            float dX = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            float dY = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            float dZ = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), stack.func_77946_l());
            float factor = 0.05f;
            entityItem.field_70159_w = Util.RANDOM.nextGaussian() * (double)factor;
            entityItem.field_70181_x = Util.RANDOM.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = Util.RANDOM.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public boolean tryToggleRedstone(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        ItemStack stack = player.func_184614_ca();
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockRedstoneTorch && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            if (!world.field_72995_K && base.isRedstoneToggle()) {
                base.isPulseMode = !base.isPulseMode;
                tile.func_70296_d();
                if (tile instanceof TileEntityBase) {
                    ((TileEntityBase)tile).sendUpdate();
                }
            }
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.getMetaProperty() == null ? super.func_176203_a(meta) : this.func_176223_P().func_177226_a((IProperty)this.getMetaProperty(), (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.getMetaProperty() == null ? super.func_176201_c(state) : ((Integer)state.func_177229_b((IProperty)this.getMetaProperty())).intValue();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityBase base;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityBase && (base = (TileEntityBase)tile).isRedstoneToggle() && base.isPulseMode) {
            base.activateOnPulse();
        }
    }

    public void neighborsChangedCustom(World world, BlockPos pos) {
        this.updateRedstoneState(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        this.neighborsChangedCustom(worldIn, pos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World) {
            this.neighborsChangedCustom((World)world, pos);
        }
    }

    public void updateRedstoneState(World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            boolean powered = world.func_175687_A(pos) > 0;
            boolean wasPowered = base.isRedstonePowered;
            if (powered && !wasPowered) {
                if (base.isRedstoneToggle() && base.isPulseMode) {
                    world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
                }
                base.setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                base.setRedstonePowered(false);
            }
        }
    }

    protected boolean checkFailUseItemOnTank(EntityPlayer player, ItemStack heldItem, FluidTank tank) {
        return heldItem == null || !FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)tank, (EntityPlayer)player);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateRedstoneState(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77942_o() && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            NBTTagCompound compound = stack.func_77978_p().func_74775_l("Data");
            base.readSyncableNBT(compound, TileEntityBase.NBTType.SAVE_BLOCK);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return this.getMetaProperty() == null ? super.func_180661_e() : new BlockStateContainer((Block)this, new IProperty[]{this.getMetaProperty()});
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            NBTTagCompound data = new NBTTagCompound();
            base.writeSyncableNBT(data, TileEntityBase.NBTType.SAVE_BLOCK);
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String key : data.func_150296_c()) {
                NBTBase tag = data.func_74781_a(key);
                if (!(tag instanceof NBTTagInt) || ((NBTTagInt)tag).func_150287_d() != 0) continue;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                data.func_82580_o(key);
            }
            ItemStack stack = new ItemStack(this.func_180660_a(state, Util.RANDOM, fortune), 1, this.func_180651_a(state));
            if (!data.func_82582_d()) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74782_a("Data", (NBTBase)data);
            }
            drops.add(stack);
        }
        return drops;
    }

    protected PropertyInteger getMetaProperty() {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

