/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBushBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockPlant;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheWildPlants;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWildPlant
extends BlockBushBase {
    public static final TheWildPlants[] ALL_WILD_PLANTS = TheWildPlants.values();
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)(ALL_WILD_PLANTS.length - 1));

    public BlockWildPlant(String name) {
        super(name);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        BlockPos offset = pos.func_177977_b();
        IBlockState offsetState = world.func_180495_p(offset);
        Block offsetBlock = offsetState.func_177230_c();
        return this.func_176201_c(state) == TheWildPlants.RICE.ordinal() ? offsetBlock.func_149688_o(offsetState) == Material.field_151586_h : offsetBlock.canSustainPlant(offsetState, (IBlockAccess)world, offset, EnumFacing.UP, (IPlantable)this);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176201_c(state);
        return metadata >= ALL_WILD_PLANTS.length ? null : new ItemStack(((BlockPlant)BlockWildPlant.ALL_WILD_PLANTS[metadata].wildVersionOf).seedItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < ALL_WILD_PLANTS.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int metadata = this.func_176201_c(state);
        return metadata >= ALL_WILD_PLANTS.length ? null : BlockWildPlant.ALL_WILD_PLANTS[metadata].wildVersionOf.getDrops(world, pos, BlockWildPlant.ALL_WILD_PLANTS[metadata].wildVersionOf.func_176203_a(7), fortune);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock((Block)this);
    }

    @Override
    public boolean shouldAddCreative() {
        return false;
    }

    @Override
    protected void registerRendering() {
        for (int i = 0; i < ALL_WILD_PLANTS.length; ++i) {
            ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Block)this, 1, i), this.getRegistryName(), META.func_177701_a() + "=" + i);
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77952_i() >= ALL_WILD_PLANTS.length ? EnumRarity.COMMON : BlockWildPlant.ALL_WILD_PLANTS[stack.func_77952_i()].rarity;
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return stack.func_77952_i() >= ALL_WILD_PLANTS.length ? "actuallyadditions.lolWutHowUDoDis" : this.func_77658_a() + BlockWildPlant.ALL_WILD_PLANTS[stack.func_77952_i()].name;
        }
    }
}

