/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPhantom
extends BlockContainerBase
implements IHudDisplay {
    public final Type type;

    public BlockPhantom(Type type, String name) {
        super(Material.field_151576_e, name);
        this.type = type;
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(4.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.type == Type.REDSTONEFACE;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.func_175625_s(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesWeak[side.ordinal()];
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.func_175625_s(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesStrong[side.ordinal()];
        }
        return super.func_176211_b(state, world, pos, side);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.type == Type.PLACER || this.type == Type.BREAKER) {
            this.dropInventory(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World world, int par2) {
        switch (this.type) {
            case PLACER: {
                return new TileEntityPhantomPlacer();
            }
            case BREAKER: {
                return new TileEntityPhantomBreaker();
            }
            case LIQUIFACE: {
                return new TileEntityPhantomLiquiface();
            }
            case ENERGYFACE: {
                return new TileEntityPhantomEnergyface();
            }
            case REDSTONEFACE: {
                return new TileEntityPhantomRedstoneface();
            }
        }
        return new TileEntityPhantomItemface();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.tryToggleRedstone(world, pos, player)) {
            return true;
        }
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof IPhantomTile && ((IPhantomTile)tile).getGuiID() != -1) {
            player.openGui((Object)ActuallyAdditions.instance, ((IPhantomTile)tile).getGuiID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
        if (tile != null && tile instanceof IPhantomTile) {
            IPhantomTile phantom = (IPhantomTile)tile;
            minecraft.field_71466_p.func_175063_a(TextFormatting.GOLD + StringUtil.localize("tooltip.actuallyadditions.blockPhantomRange.desc") + ": " + phantom.getRange(), (float)(resolution.func_78326_a() / 2 + 5), (float)(resolution.func_78328_b() / 2 - 40), 0xFFFFFF);
            if (phantom.hasBoundPosition()) {
                int distance = (int)new Vec3d((Vec3i)posHit.func_178782_a()).func_72438_d(new Vec3d((Vec3i)phantom.getBoundPosition()));
                IBlockState state = minecraft.field_71441_e.func_180495_p(phantom.getBoundPosition());
                Block block = state.func_177230_c();
                Item item = Item.func_150898_a((Block)block);
                String name = item == null ? "Absolutely Nothing" : item.func_77653_i(new ItemStack(block, 1, block.func_176201_c(state)));
                StringUtil.drawSplitString(minecraft.field_71466_p, StringUtil.localizeFormatted("tooltip.actuallyadditions.phantom.blockInfo.desc", name, phantom.getBoundPosition().func_177958_n(), phantom.getBoundPosition().func_177956_o(), phantom.getBoundPosition().func_177952_p(), distance), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 - 30, 200, 0xFFFFFF, true);
                if (phantom.isBoundThingInRange()) {
                    StringUtil.drawSplitString(minecraft.field_71466_p, TextFormatting.DARK_GREEN + StringUtil.localize("tooltip.actuallyadditions.phantom.connectedRange.desc"), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 25, 200, 0xFFFFFF, true);
                } else {
                    StringUtil.drawSplitString(minecraft.field_71466_p, TextFormatting.DARK_RED + StringUtil.localize("tooltip.actuallyadditions.phantom.connectedNoRange.desc"), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 25, 200, 0xFFFFFF, true);
                }
            } else {
                minecraft.field_71466_p.func_175063_a(TextFormatting.RED + StringUtil.localize("tooltip.actuallyadditions.phantom.notConnected.desc"), (float)(resolution.func_78326_a() / 2 + 5), (float)(resolution.func_78328_b() / 2 + 25), 0xFFFFFF);
            }
        }
    }

    public static enum Type {
        FACE,
        PLACER,
        BREAKER,
        LIQUIFACE,
        ENERGYFACE,
        REDSTONEFACE;

    }
}

