/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaserRelay
extends BlockContainerBase {
    private static final float F = 0.0625f;
    private static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.9375, 0.875);
    private static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.125, 0.0625, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.0625, 0.0625, 0.875, 0.9375, 1.0);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0625, 0.125, 0.9375, 0.9375, 0.875);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.0625, 0.0, 0.875, 0.9375, 0.9375);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0625, 0.0625, 0.125, 1.0, 0.9375, 0.875);
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)5);
    private final Type type;

    public BlockLaserRelay(String name, Type type) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.type = type;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.func_176201_c(state)) {
            case 1: {
                return AABB_UP;
            }
            case 2: {
                return AABB_NORTH;
            }
            case 3: {
                return AABB_SOUTH;
            }
            case 4: {
                return AABB_WEST;
            }
            case 5: {
                return AABB_EAST;
            }
        }
        return AABB_DOWN;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase base) {
        return this.func_176203_a(side.ordinal());
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing par6, float par7, float par8, float par9) {
        TileEntityLaserRelay relay;
        if (player.func_70093_af() && (relay = (TileEntityLaserRelay)world.func_175625_s(pos)) instanceof TileEntityLaserRelayItemWhitelist) {
            if (!world.field_72995_K) {
                player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.LASER_RELAY_ITEM_WHITELIST.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public void neighborsChangedCustom(World world, BlockPos pos) {
        super.neighborsChangedCustom(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLaserRelay) {
            ((TileEntityLaserRelay)tile).saveAllHandlersAround();
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        switch (this.type) {
            case ITEM: {
                return new TileEntityLaserRelayItem();
            }
            case ITEM_WHITELIST: {
                return new TileEntityLaserRelayItemWhitelist();
            }
            case ENERGY_ADVANCED: {
                return new TileEntityLaserRelayEnergyAdvanced();
            }
            case ENERGY_EXTREME: {
                return new TileEntityLaserRelayEnergyExtreme();
            }
        }
        return new TileEntityLaserRelayEnergy();
    }

    public static enum Type {
        ENERGY_BASIC,
        ENERGY_ADVANCED,
        ENERGY_EXTREME,
        ITEM,
        ITEM_WHITELIST;

    }
}

