/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.booklet.entry.EntrySet;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBookletStand;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBookletStand
extends BlockContainerBase
implements IHudDisplay {
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)3);
    private static final AxisAlignedBB AABB_1 = new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.875, 0.0625);
    private static final AxisAlignedBB AABB_2 = new AxisAlignedBB(0.0, 0.1875, 0.0, 0.0625, 0.875, 1.0);
    private static final AxisAlignedBB AABB_3 = new AxisAlignedBB(0.9375, 0.1875, 0.0, 1.0, 0.875, 1.0);
    private static final AxisAlignedBB AABB_4 = new AxisAlignedBB(1.0, 0.1875, 0.9375, 0.0, 0.875, 1.0);

    public BlockBookletStand(String name) {
        super(Material.field_151575_d, name);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(1.0f);
        this.func_149752_b(4.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = this.func_176201_c(state);
        switch (meta) {
            case 0: {
                return AABB_4;
            }
            case 1: {
                return AABB_1;
            }
            case 2: {
                return AABB_3;
            }
            case 3: {
                return AABB_2;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing par6, float par7, float par8, float par9) {
        player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.BOOK_STAND.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        TileEntityBookletStand tile;
        int rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rotation == 0) {
            world.func_180501_a(pos, this.func_176203_a(0), 2);
        }
        if (rotation == 1) {
            world.func_180501_a(pos, this.func_176203_a(3), 2);
        }
        if (rotation == 2) {
            world.func_180501_a(pos, this.func_176203_a(1), 2);
        }
        if (rotation == 3) {
            world.func_180501_a(pos, this.func_176203_a(2), 2);
        }
        if ((tile = (TileEntityBookletStand)world.func_175625_s(pos)) != null && tile.assignedPlayer == null) {
            tile.assignedPlayer = player.func_70005_c_();
            tile.func_70296_d();
            tile.sendUpdate();
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityBookletStand();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
        if (tile instanceof TileEntityBookletStand) {
            String strg2;
            String strg1;
            EntrySet set = ((TileEntityBookletStand)tile).assignedEntry;
            if (set.getCurrentEntry() == null) {
                strg1 = "No entry saved! Save one if";
                strg2 = "you are the player who placed it!";
            } else if (set.getCurrentChapter() == null) {
                strg1 = set.getCurrentEntry().getLocalizedName();
                strg2 = "Page " + set.getPageInIndex();
            } else {
                strg1 = set.getCurrentChapter().getLocalizedName();
                strg2 = "Page " + set.getCurrentPage().getID();
                AssetUtil.renderStackToGui(set.getCurrentChapter().getDisplayItemStack() != null ? set.getCurrentChapter().getDisplayItemStack() : new ItemStack(InitItems.itemBooklet), resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 10, 1.0f);
            }
            minecraft.field_71466_p.func_175063_a(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + strg1, (float)(resolution.func_78326_a() / 2 + 25), (float)(resolution.func_78328_b() / 2 + 8), 0xFFFFFF);
            minecraft.field_71466_p.func_175063_a(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + strg2, (float)(resolution.func_78326_a() / 2 + 25), (float)(resolution.func_78328_b() / 2 + 18), 0xFFFFFF);
        }
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }
}

