/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAtomicReconstructor
extends BlockContainerBase
implements IHudDisplay {
    public static final int NAME_FLAVOR_AMOUNTS_1 = 12;
    public static final int NAME_FLAVOR_AMOUNTS_2 = 14;
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)5);

    public BlockAtomicReconstructor(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(10.0f);
        this.func_149752_b(80.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing par6, float par7, float par8, float par9) {
        TileEntityAtomicReconstructor reconstructor;
        if (this.tryToggleRedstone(world, pos, player)) {
            return true;
        }
        if (!world.field_72995_K && (reconstructor = (TileEntityAtomicReconstructor)world.func_175625_s(pos)) != null) {
            if (heldItem != null) {
                Item item = heldItem.func_77973_b();
                if (item instanceof ILensItem && reconstructor.func_70301_a(0) == null) {
                    ItemStack toPut = heldItem.func_77946_l();
                    toPut.field_77994_a = 1;
                    reconstructor.func_70299_a(0, toPut);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                } else if (item == Items.field_151086_cn) {
                    ++reconstructor.counter;
                    reconstructor.func_70296_d();
                }
            } else {
                ItemStack slot = reconstructor.func_70301_a(0);
                if (slot != null) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, slot.func_77946_l());
                    reconstructor.func_70299_a(0, null);
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityAtomicReconstructor();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropInventory(world, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
        if (tile instanceof TileEntityAtomicReconstructor) {
            String strg;
            ItemStack slot = ((TileEntityAtomicReconstructor)tile).func_70301_a(0);
            if (slot == null) {
                strg = StringUtil.localize("info.actuallyadditions.noLens");
            } else {
                strg = slot.func_77973_b().func_77653_i(slot);
                AssetUtil.renderStackToGui(slot, resolution.func_78326_a() / 2 + 15, resolution.func_78328_b() / 2 - 19, 1.0f);
            }
            minecraft.field_71466_p.func_175063_a(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + strg, (float)(resolution.func_78326_a() / 2 + 35), (float)(resolution.func_78328_b() / 2 - 15), 0xFFFFFF);
        }
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock((Block)this);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)player).ordinal();
        world.func_180501_a(pos, this.func_176203_a(rotation), 2);
        super.func_180633_a(world, pos, state, player, stack);
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        private long lastSysTime;
        private int toPick1;
        private int toPick2;

        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(false);
            this.func_77656_e(0);
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return this.func_77658_a();
        }

        @Override
        public int func_77647_b(int damage) {
            return damage;
        }

        public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean bool) {
            long sysTime = System.currentTimeMillis();
            if (this.lastSysTime + 3000L < sysTime) {
                this.lastSysTime = sysTime;
                this.toPick1 = Util.RANDOM.nextInt(12) + 1;
                this.toPick2 = Util.RANDOM.nextInt(14) + 1;
            }
            String base = "tile.actuallyadditions." + ((BlockAtomicReconstructor)this.field_150939_a).getBaseName() + ".info.";
            list.add(StringUtil.localize(base + "1." + this.toPick1) + " " + StringUtil.localize(base + "2." + this.toPick2));
        }
    }
}

