/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.achievement;

import de.ellpeck.actuallyadditions.mod.achievement.InitAchievements;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheCrystals;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.JsonSerializableSet;

public enum TheAchievements {
    OPEN_BOOKLET("openBooklet", 0, 0, new ItemStack(InitItems.itemBooklet), null, InitAchievements.Type.MISC, new ItemStack[0]),
    NAME_SMILEY_CLOUD("nameSmileyCloud", 4, 3, new ItemStack(InitBlocks.blockSmileyCloud), null, InitAchievements.Type.MISC, true, 0, new ItemStack[0]),
    OPEN_TREASURE_CHEST("openTreasureChest", 1, -3, new ItemStack(InitBlocks.blockTreasureChest), OPEN_BOOKLET, InitAchievements.Type.MISC, new ItemStack[0]),
    CRAFT_COAL_GEN("craftCoalGen", -2, 0, new ItemStack(InitBlocks.blockCoalGenerator), OPEN_BOOKLET, new ItemStack[0]),
    CRAFT_LEAF_GEN("craftLeafGen", -3, -2, new ItemStack(InitBlocks.blockLeafGenerator), CRAFT_COAL_GEN, new ItemStack[0]),
    CRAFT_RECONSTRUCTOR("craftReconstructor", -5, 0, new ItemStack(InitBlocks.blockAtomicReconstructor), CRAFT_COAL_GEN, new ItemStack[0]),
    MAKE_FIRST_CRYSTAL("makeCrystal", -4, 2, new ItemStack(InitItems.itemCrystal, 1, TheCrystals.EMERALD.ordinal()), CRAFT_RECONSTRUCTOR, InitAchievements.Type.PICK_UP, new ItemStack(InitItems.itemCrystal, 1, Short.MAX_VALUE), new ItemStack(InitBlocks.blockCrystal, 1, Short.MAX_VALUE)),
    CRAFT_EMPOWERER("craftEmpowerer", -4, 4, new ItemStack(InitBlocks.blockEmpowerer), MAKE_FIRST_CRYSTAL, new ItemStack[0]),
    CRAFT_PHANTOMFACE("craftPhantomface", 2, 0, new ItemStack(InitBlocks.blockPhantomface), OPEN_BOOKLET, new ItemStack[0]),
    CRAFT_LIQUIFACE("craftLiquiface", 2, 2, new ItemStack(InitBlocks.blockPhantomLiquiface), CRAFT_PHANTOMFACE, new ItemStack[0]),
    CRAFT_ENERGYFACE("craftEnergyface", 4, -1, new ItemStack(InitBlocks.blockPhantomEnergyface), CRAFT_PHANTOMFACE, new ItemStack[0]),
    CRAFT_LASER_RELAY("craftLaserRelay", -7, -2, new ItemStack(InitBlocks.blockLaserRelay), CRAFT_RECONSTRUCTOR, new ItemStack[0]),
    CRAFT_LASER_RELAY_ITEM("craftLaserRelayItem", -9, -2, new ItemStack(InitBlocks.blockLaserRelayItem), CRAFT_LASER_RELAY, new ItemStack[0]),
    CRAFT_ITEM_INTERFACE("craftItemInterface", -11, -3, new ItemStack(InitBlocks.blockItemViewer), CRAFT_LASER_RELAY_ITEM, new ItemStack[0]),
    CRAFT_LASER_RELAY_ADVANCED("craftLaserRelayAdvanced", -7, -4, new ItemStack(InitBlocks.blockLaserRelayAdvanced), CRAFT_LASER_RELAY, new ItemStack[0]),
    CRAFT_LASER_RELAY_EXTREME("craftLaserRelayExtreme", -9, -4, new ItemStack(InitBlocks.blockLaserRelayExtreme), CRAFT_LASER_RELAY_ADVANCED, new ItemStack[0]),
    CRAFT_CRUSHER("craftCrusher", -8, 0, new ItemStack(InitBlocks.blockGrinder), CRAFT_RECONSTRUCTOR, new ItemStack[0]),
    CRAFT_DOUBLE_CRUSHER("craftDoubleCrusher", -10, 1, new ItemStack(InitBlocks.blockGrinderDouble), CRAFT_CRUSHER, new ItemStack[0]),
    PICK_UP_COFFEE("pickUpCoffee", -2, 2, new ItemStack(InitItems.itemCoffeeBean), CRAFT_COAL_GEN, InitAchievements.Type.PICK_UP, new ItemStack[0]),
    CRAFT_COFFEE_MACHINE("craftCoffeeMachine", -1, 3, new ItemStack(InitBlocks.blockCoffeeMachine), PICK_UP_COFFEE, new ItemStack[0]),
    CRAFT_FIREWORK_BOX("craftFireworkBox", -4, -5, new ItemStack(InitBlocks.blockFireworkBox), null, InitAchievements.Type.CRAFTING, true, 0, new ItemStack[0]),
    GET_UNPROBED("getUnProbed", -7, 3, new ItemStack(InitItems.itemPlayerProbe), null, InitAchievements.Type.MISC, true, 0, new ItemStack[0]),
    GET_CRYSTALS_MILESTONE("getCrystalsMilestone", 6, -3, new ItemStack(InitBlocks.blockCrystal, 1, TheCrystals.DIAMOND.ordinal()), null, InitAchievements.Type.PICK_UP, true, 200, new ItemStack(InitItems.itemCrystal, 1, Short.MAX_VALUE), new ItemStack(InitBlocks.blockCrystal, 1, Short.MAX_VALUE)),
    OPEN_BOOKLET_MILESTONE("openBookletMilestone", 6, -1, new ItemStack(InitItems.itemBooklet), null, InitAchievements.Type.MISC, true, 50, new ItemStack[0]);

    public final Achievement chieve;
    public final InitAchievements.Type type;
    public final int progressToReach;
    public List<ItemStack> itemsToBeGotten;

    private TheAchievements(String name, int x, int y, ItemStack displayStack, TheAchievements hasToHaveBefore, ItemStack ... specialItemsToBeGotten) {
        this(name, x, y, displayStack, hasToHaveBefore, InitAchievements.Type.CRAFTING, false, 0, specialItemsToBeGotten);
    }

    private TheAchievements(String name, int x, int y, ItemStack displayStack, TheAchievements hasToHaveBefore, InitAchievements.Type type, boolean special, int progressToReach, ItemStack ... specialItemsToBeGotten) {
        this.type = type;
        this.progressToReach = progressToReach;
        this.chieve = new Achievement("achievement.actuallyadditions." + name, "actuallyadditions." + name, x, y, displayStack, hasToHaveBefore == null ? null : hasToHaveBefore.chieve);
        if (hasToHaveBefore == null) {
            this.chieve.func_75966_h();
        }
        if (special) {
            this.chieve.func_75987_b();
        }
        if (progressToReach > 0) {
            this.chieve.func_150953_b(JsonSerializableSet.class);
        }
        this.chieve.func_75971_g();
        this.itemsToBeGotten = specialItemsToBeGotten == null || specialItemsToBeGotten.length <= 0 ? Collections.singletonList(displayStack) : Arrays.asList(specialItemsToBeGotten);
    }

    private TheAchievements(String name, int x, int y, ItemStack displayStack, TheAchievements hasToHaveBefore, InitAchievements.Type type, ItemStack ... specialItemsToBeGotten) {
        this(name, x, y, displayStack, hasToHaveBefore, type, false, 0, specialItemsToBeGotten);
    }

    public void get(EntityPlayer player) {
        this.get(player, 1);
    }

    public void get(EntityPlayer player, int amount) {
        if (this.progressToReach > 0) {
            this.updateStatus(player, amount);
        } else {
            player.func_71029_a((StatBase)this.chieve);
        }
    }

    private void updateStatus(EntityPlayer player, int amount) {
        StatisticsManagerServer manager;
        if (player instanceof EntityPlayerMP && (manager = ((EntityPlayerMP)player).func_147099_x()) != null && !manager.func_77443_a(this.chieve) && manager.func_77442_b(this.chieve)) {
            JsonSerializableSet data = (JsonSerializableSet)manager.func_150870_b((StatBase)this.chieve);
            if (data == null) {
                data = (JsonSerializableSet)manager.func_150872_a((StatBase)this.chieve, (IJsonSerializable)new JsonSerializableSet());
            }
            int gottenSoFar = 0;
            for (String strg : data) {
                try {
                    int i = Integer.parseInt(strg);
                    gottenSoFar += i;
                    data.remove((Object)strg);
                }
                catch (Exception e) {
                    data.remove((Object)strg);
                }
            }
            if ((gottenSoFar += amount) >= this.progressToReach) {
                player.func_71029_a((StatBase)this.chieve);
            } else {
                data.add((Object)Integer.toString(gottenSoFar));
            }
        }
    }
}

