/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.achievement.InitAchievements;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.InitBooklet;
import de.ellpeck.actuallyadditions.mod.config.ConfigurationHandler;
import de.ellpeck.actuallyadditions.mod.crafting.CrusherCrafting;
import de.ellpeck.actuallyadditions.mod.crafting.InitCrafting;
import de.ellpeck.actuallyadditions.mod.crafting.ItemCrafting;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.event.CommonEvents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.gen.InitVillager;
import de.ellpeck.actuallyadditions.mod.gen.OreGen;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitForeignPaxels;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.lens.LensRecipeHandler;
import de.ellpeck.actuallyadditions.mod.items.lens.Lenses;
import de.ellpeck.actuallyadditions.mod.material.InitArmorMaterials;
import de.ellpeck.actuallyadditions.mod.material.InitToolMaterials;
import de.ellpeck.actuallyadditions.mod.misc.BannerHelper;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.misc.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.misc.MethodHandler;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.ore.InitOreDict;
import de.ellpeck.actuallyadditions.mod.proxy.IProxy;
import de.ellpeck.actuallyadditions.mod.recipe.EmpowererHandler;
import de.ellpeck.actuallyadditions.mod.recipe.FuelHandler;
import de.ellpeck.actuallyadditions.mod.recipe.HairyBallHandler;
import de.ellpeck.actuallyadditions.mod.recipe.TreasureChestHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.Locale;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="actuallyadditions", name="Actually Additions", version="1.10.2-r60", dependencies="after:BuildCraft|Energy", guiFactory="de.ellpeck.actuallyadditions.mod.config.GuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class ActuallyAdditions {
    @Mod.Instance(value="actuallyadditions")
    public static ActuallyAdditions instance;
    @SidedProxy(clientSide="de.ellpeck.actuallyadditions.mod.proxy.ClientProxy", serverSide="de.ellpeck.actuallyadditions.mod.proxy.ServerProxy")
    public static IProxy proxy;
    public static boolean teslaLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModUtil.LOGGER.info("Starting PreInitialization Phase...");
        ActuallyAdditionsAPI.methodHandler = new MethodHandler();
        ActuallyAdditionsAPI.connectionHandler = new LaserRelayConnectionHandler();
        Lenses.init();
        InitBooklet.preInit();
        if (Loader.isModLoaded((String)"tesla")) {
            ModUtil.LOGGER.info("Tesla loaded... Activating Tesla Power System integration...");
            teslaLoaded = true;
        } else {
            ModUtil.LOGGER.info("Tesla not found! Skipping Tesla Power System integration.");
        }
        new ConfigurationHandler(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        InitToolMaterials.init();
        InitArmorMaterials.init();
        InitBlocks.init();
        InitFluids.init();
        InitItems.init();
        FuelHandler.init();
        BannerHelper.init();
        SoundHandler.init();
        new UpdateChecker();
        proxy.preInit(event);
        ModUtil.LOGGER.info("PreInitialization Finished.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModUtil.LOGGER.info("Starting Initialization Phase...");
        InitOreDict.init();
        InitAchievements.init();
        GuiHandler.init();
        new OreGen();
        TileEntityBase.init();
        new CommonEvents();
        InitCrafting.init();
        DungeonLoot.init();
        InitEntities.init();
        proxy.init(event);
        ModUtil.LOGGER.info("Initialization Finished.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModUtil.LOGGER.info("Starting PostInitialization Phase...");
        InitVillager.init();
        ItemCoffee.initIngredients();
        CrusherCrafting.init();
        ItemCrafting.initMashedFoodRecipes();
        HairyBallHandler.init();
        TreasureChestHandler.init();
        LensRecipeHandler.init();
        EmpowererHandler.init();
        InitForeignPaxels.init();
        InitBooklet.postInit();
        proxy.postInit(event);
        ModUtil.LOGGER.info("PostInitialization Finished.");
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            String name;
            if (mapping.name == null || !(name = mapping.name.toLowerCase(Locale.ROOT)).startsWith("actuallyadditions:") || !name.contains("paxel") && !name.contains("itemspecial") && !name.contains("blockbookstand") && !name.contains("rarmor") && !name.contains("bucket") && !name.contains("modulereconstructor")) continue;
            mapping.ignore();
            ModUtil.LOGGER.info("Missing Mapping " + mapping.name + " is getting ignored. This is intentional.");
        }
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

