/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api.laser;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class ConnectionPair {
    public final BlockPos[] positions = new BlockPos[2];
    public final boolean suppressConnectionRender;

    public ConnectionPair(BlockPos firstRelay, BlockPos secondRelay, boolean suppressConnectionRender) {
        this.positions[0] = firstRelay;
        this.positions[1] = secondRelay;
        this.suppressConnectionRender = suppressConnectionRender;
    }

    public static ConnectionPair readFromNBT(NBTTagCompound compound) {
        if (compound != null) {
            BlockPos[] pos = new BlockPos[2];
            for (int i = 0; i < pos.length; ++i) {
                int anX = compound.func_74762_e("x" + i);
                int aY = compound.func_74762_e("y" + i);
                int aZ = compound.func_74762_e("z" + i);
                pos[i] = new BlockPos(anX, aY, aZ);
            }
            return new ConnectionPair(pos[0], pos[1], compound.func_74767_n("SuppressRender"));
        }
        return null;
    }

    public boolean contains(BlockPos relay) {
        for (BlockPos position : this.positions) {
            if (position == null || !position.equals((Object)relay)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.positions[0] == null ? "-" : this.positions[0].toString()) + " | " + (this.positions[1] == null ? "-" : this.positions[1].toString());
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (int i = 0; i < this.positions.length; ++i) {
            BlockPos relay = this.positions[i];
            compound.func_74768_a("x" + i, relay.func_177958_n());
            compound.func_74768_a("y" + i, relay.func_177956_o());
            compound.func_74768_a("z" + i, relay.func_177952_p());
        }
        compound.func_74757_a("SuppressRender", this.suppressConnectionRender);
        return compound;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionPair) {
            ConnectionPair pair = (ConnectionPair)obj;
            for (int i = 0; i < this.positions.length; ++i) {
                if (this.positions[i] != pair.positions[i] && (this.positions[i] == null || !this.positions[i].equals((Object)pair.positions[i]))) continue;
                return true;
            }
        }
        return super.equals(obj);
    }
}

