/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api;

import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.lens.LensConversion;
import de.ellpeck.actuallyadditions.api.recipe.BallOfFurReturn;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.api.recipe.IColorLensChanger;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.api.recipe.TreasureChestLoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ActuallyAdditionsAPI {
    public static final String MOD_ID = "actuallyadditions";
    public static final String API_ID = "actuallyadditionsapi";
    public static final String API_VERSION = "21";
    public static final List<CrusherRecipe> CRUSHER_RECIPES = new ArrayList<CrusherRecipe>();
    public static final List<BallOfFurReturn> BALL_OF_FUR_RETURN_ITEMS = new ArrayList<BallOfFurReturn>();
    public static final List<TreasureChestLoot> TREASURE_CHEST_LOOT = new ArrayList<TreasureChestLoot>();
    public static final List<LensConversionRecipe> RECONSTRUCTOR_LENS_CONVERSION_RECIPES = new ArrayList<LensConversionRecipe>();
    public static final List<EmpowererRecipe> EMPOWERER_RECIPES = new ArrayList<EmpowererRecipe>();
    public static final Map<Item, IColorLensChanger> RECONSTRUCTOR_LENS_COLOR_CHANGERS = new HashMap<Item, IColorLensChanger>();
    public static final List<CoffeeIngredient> COFFEE_MACHINE_INGREDIENTS = new ArrayList<CoffeeIngredient>();
    public static final List<CompostRecipe> COMPOST_RECIPES = new ArrayList<CompostRecipe>();
    public static final List<IBookletEntry> BOOKLET_ENTRIES = new ArrayList<IBookletEntry>();
    public static final List<BookletPage> BOOKLET_PAGES_WITH_ITEM_DATA = new ArrayList<BookletPage>();
    public static IMethodHandler methodHandler;
    public static ILaserRelayConnectionHandler connectionHandler;
    public static IBookletEntry entryGettingStarted;
    public static IBookletEntry entryReconstruction;
    public static IBookletEntry entryFunctionalNonRF;
    public static IBookletEntry entryFunctionalRF;
    public static IBookletEntry entryGeneratingRF;
    public static IBookletEntry entryItemsNonRF;
    public static IBookletEntry entryItemsRF;
    public static IBookletEntry entryMisc;
    public static IBookletEntry allAndSearch;
    public static LensConversion lensDefaultConversion;
    public static Lens lensDetonation;
    public static Lens lensDeath;
    public static Lens lensColor;
    public static Lens lensDisruption;
    public static Lens lensDisenchanting;

    public static void addCrusherRecipe(String input, String outputOne, int outputOneAmount) {
        ActuallyAdditionsAPI.addCrusherRecipe(input, outputOne, outputOneAmount, "", 0, 0);
    }

    public static void addCrusherRecipe(String input, String outputOne, int outputOneAmount, String outputTwo, int outputTwoAmount, int outputTwoChance) {
        if (!(OreDictionary.getOres((String)input, (boolean)false).isEmpty() || OreDictionary.getOres((String)outputOne, (boolean)false).isEmpty() || outputTwo != null && !outputTwo.isEmpty() && OreDictionary.getOres((String)outputTwo, (boolean)false).isEmpty())) {
            CRUSHER_RECIPES.add(new CrusherRecipe(input, outputOne, outputOneAmount, outputTwo, outputTwoAmount, outputTwoChance));
        }
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack outputOne) {
        ActuallyAdditionsAPI.addCrusherRecipe(input, outputOne, null, 0);
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack outputOne, ItemStack outputTwo, int outputTwoChance) {
        CRUSHER_RECIPES.add(new CrusherRecipe(input, outputOne, outputTwo, outputTwoChance));
    }

    public static void addCrusherRecipe(ItemStack input, String outputOne, int outputOneAmount) {
        if (!OreDictionary.getOres((String)outputOne, (boolean)false).isEmpty()) {
            CRUSHER_RECIPES.add(new CrusherRecipe(input, outputOne, outputOneAmount));
        }
    }

    public static void addCompostRecipe(ItemStack input, Block inputDisplay, ItemStack output, Block outputDisplay) {
        COMPOST_RECIPES.add(new CompostRecipe(input, inputDisplay, output, outputDisplay));
    }

    public static void addBallOfFurReturnItem(ItemStack stack, int chance) {
        BALL_OF_FUR_RETURN_ITEMS.add(new BallOfFurReturn(stack, chance));
    }

    public static void addTreasureChestLoot(ItemStack stack, int chance, int minAmount, int maxAmount) {
        TREASURE_CHEST_LOOT.add(new TreasureChestLoot(stack, chance, minAmount, maxAmount));
    }

    public static void addEmpowererRecipe(ItemStack input, ItemStack output, ItemStack modifier1, ItemStack modifier2, ItemStack modifier3, ItemStack modifier4, int energyPerStand, int time, float[] particleColor) {
        EMPOWERER_RECIPES.add(new EmpowererRecipe(input, output, modifier1, modifier2, modifier3, modifier4, energyPerStand, time, particleColor));
    }

    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse, LensConversion type) {
        RECONSTRUCTOR_LENS_CONVERSION_RECIPES.add(new LensConversionRecipe(input, output, energyUse, type));
    }

    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse) {
        ActuallyAdditionsAPI.addReconstructorLensConversionRecipe(input, output, energyUse, lensDefaultConversion);
    }

    public static void addReconstructorLensConversionRecipe(String input, String output, int energyUse, LensConversion type) {
        RECONSTRUCTOR_LENS_CONVERSION_RECIPES.add(new LensConversionRecipe(input, output, energyUse, type));
    }

    public static void addReconstructorLensConversionRecipe(String input, String output, int energyUse) {
        ActuallyAdditionsAPI.addReconstructorLensConversionRecipe(input, output, energyUse, lensDefaultConversion);
    }

    public static void addReconstructorLensColorChangeItem(Item item, IColorLensChanger changer) {
        RECONSTRUCTOR_LENS_COLOR_CHANGERS.put(item, changer);
    }

    public static void addCoffeeMachineIngredient(CoffeeIngredient ingredient) {
        COFFEE_MACHINE_INGREDIENTS.add(ingredient);
    }

    public static void addBookletEntry(IBookletEntry entry) {
        BOOKLET_ENTRIES.add(entry);
    }

    public static void addPageWithItemStackData(BookletPage page) {
        BOOKLET_PAGES_WITH_ITEM_DATA.add(page);
    }
}

