/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.MathUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntitySmallFloodlight
extends TileEntityFLElectric {
    private boolean rotationState = false;

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("teRotationState")) {
            this.rotationState = nbtTagCompound.func_74767_n("teRotationState");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("teRotationState", this.rotationState);
        return nbtTagCompound;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        return facing.func_176734_d().ordinal() == this.orientation.ordinal();
    }

    public void toggleRotationState() {
        this.rotationState = !this.rotationState;
        this.field_145850_b.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
    }

    public boolean getRotationState() {
        return this.rotationState;
    }

    public void setRotationState(boolean rotationState) {
        this.rotationState = rotationState;
    }

    public void smallSource(boolean remove) {
        for (int i = 0; i < 5; ++i) {
            TileEntityPhantomLight light;
            int a = 0;
            int b = 0;
            int c = 0;
            if (i == 0) {
                a = 1;
                c = 0;
                b = 0;
            } else if (i == 1) {
                c = 0;
                a = 0;
                b = 1;
            } else if (i == 2) {
                c = 0;
                a = 0;
                b = -1;
            } else if (i == 3) {
                b = 0;
                a = 0;
                c = 1;
            } else if (i == 4) {
                b = 0;
                a = 0;
                c = -1;
            }
            int[] rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
            int x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
            int y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
            int z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
            if (remove) {
                if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.blockPhantomLight) continue;
                light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
                light.removeSource(this.field_174879_c);
                continue;
            }
            if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().isAir(this.field_145850_b.func_180495_p(new BlockPos(x, y, z)), (IBlockAccess)this.field_145850_b, new BlockPos(x, y, z))) {
                this.setLight(new BlockPos(x, y, z));
                continue;
            }
            if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.blockPhantomLight) continue;
            light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
            light.addSource(this.field_174879_c);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsageSmallFloodlight;
            this.tryDischargeItem(this.inventory[0]);
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (this.update) {
                    this.smallSource(true);
                    this.smallSource(false);
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                    this.update = false;
                } else if (!this.wasActive) {
                    this.smallSource(false);
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                this.smallSource(true);
                world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
                world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }
}

