/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class TileEntityPhantomLight
extends TileEntity {
    private ArrayList<BlockPos> sources = new ArrayList();

    void addSource(BlockPos pos) {
        if (this.sources.contains(pos)) {
            return;
        }
        this.sources.add(pos);
    }

    private void removeSource(Iterator<BlockPos> iter, boolean remove) {
        iter.remove();
        if (this.sources.isEmpty() && this.func_145830_o() && remove) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    void removeSource(BlockPos pos) {
        this.sources.remove(pos);
        if (this.sources.isEmpty() && this.func_145830_o()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void updateAllSources(boolean remove) {
        Iterator<BlockPos> iter = this.sources.iterator();
        while (iter.hasNext()) {
            BlockPos pos = iter.next();
            if (this.field_145850_b == null) continue;
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te != null && te instanceof TileEntityMetaFloodlight) {
                ((TileEntityMetaFloodlight)te).toggleUpdateRun();
                continue;
            }
            this.removeSource(iter, remove);
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("sources")) {
            NBTTagList list = nbtTagCompound.func_150295_c("sources", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.sources.add(GeneralUtil.getPosFromIntArray(list.func_150306_c(i)));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        if (!this.sources.isEmpty()) {
            NBTTagList SourceList = new NBTTagList();
            for (BlockPos source : this.sources) {
                SourceList.func_74742_a((NBTBase)new NBTTagIntArray(GeneralUtil.getIntArrayFromPos(source)));
            }
            nbtTagCompound.func_74782_a("sources", (NBTBase)SourceList);
        }
        return nbtTagCompound;
    }
}

