/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockPhantomLight;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;

public class TileEntityMetaFloodlight
extends TileEntityFL
implements ISidedInventory,
ITickable {
    protected boolean active;
    protected boolean wasActive = false;
    protected boolean update = true;
    protected int timeout;
    protected ItemStack[] inventory = new ItemStack[1];

    public void setRedstone(boolean b) {
        this.active = b ^ this.inverted;
        this.setState((byte)(this.active ? 1 : 0));
        this.field_145850_b.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
        this.active = !this.active;
        this.setState((byte)(this.active ? 1 : 0));
        this.field_145850_b.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
    }

    public boolean getWasActive() {
        return this.wasActive;
    }

    public void setWasActive(boolean wasActive) {
        this.wasActive = wasActive;
    }

    public void toggleUpdateRun() {
        this.update = true;
    }

    public void setLight(BlockPos pos) {
        if (this.field_145850_b.func_180495_p(pos).func_177230_c() == ModBlocks.blockUVLightBlock) {
            return;
        }
        if (this.field_145850_b.func_180501_a(pos, ModBlocks.blockPhantomLight.func_176223_P(), 3)) {
            TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(pos);
            light.addSource(this.field_174879_c);
        } else {
            this.toggleUpdateRun();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.update && !this.active) {
            this.update = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        NBTTagList list;
        NBTTagCompound item;
        byte slot;
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("teMode")) {
            boolean bl = this.active = nbtTagCompound.func_74762_e("teMode") != 0;
        }
        if (nbtTagCompound.func_74764_b("wasActive")) {
            this.wasActive = nbtTagCompound.func_74767_n("wasActive");
        }
        if (nbtTagCompound.func_74764_b("Items") && (slot = (item = (list = nbtTagCompound.func_150295_c("Items", 10)).func_150305_b(0)).func_74771_c("Items")) >= 0 && slot < this.func_70302_i_()) {
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("wasActive", this.wasActive);
        nbtTagCompound.func_74774_a("teMode", this.state);
        NBTTagList list = new NBTTagList();
        ItemStack itemstack = this.func_70301_a(0);
        if (itemstack != null) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Items", (byte)0);
            itemstack.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)list);
        return nbtTagCompound;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return new int[]{0};
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing facing) {
        return true;
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing facing) {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        this.field_145850_b.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemstack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return itemstack;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void setSource(BlockPos blockPos, boolean remove, Integer setSourceUpdate) {
        if (remove) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight && setSourceUpdate == 0) {
                TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(blockPos);
                light.removeSource(this.field_174879_c);
            } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight) {
                this.field_145850_b.func_180501_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(false)), 4);
            }
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight && setSourceUpdate == 2) {
            this.field_145850_b.func_180501_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(false)), 4);
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight && setSourceUpdate == 0) {
            this.field_145850_b.func_180501_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(true)), 4);
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight) {
            TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(blockPos);
            light.addSource(this.field_174879_c);
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c().isAir(this.field_145850_b.func_180495_p(blockPos), (IBlockAccess)this.field_145850_b, blockPos) && setSourceUpdate == 1) {
            this.setLight(blockPos);
        }
    }

    public void straightSource(boolean remove) {
        int k;
        int n = k = remove ? 1 : 2;
        while (k >= 0) {
            for (int i = 1; i <= ConfigHandler.rangeStraightFloodlight; ++i) {
                int x = this.field_174879_c.func_177958_n() + this.orientation.func_82601_c() * i;
                int y = this.field_174879_c.func_177956_o() + this.orientation.func_96559_d() * i;
                int z = this.field_174879_c.func_177952_p() + this.orientation.func_82599_e() * i;
                this.setSource(new BlockPos(x, y, z), remove, k);
                if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x, y, z))) && !remove) break;
            }
            --k;
        }
    }

    public void wideConeSource(boolean remove) {
        int k;
        int n = k = remove ? 1 : 2;
        while (k >= 0) {
            boolean[] failedBeams = new boolean[9];
            if (!remove && this.field_145850_b.func_180495_p(GeneralUtil.getPosFromPosFacing(this.field_174879_c, this.orientation)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(GeneralUtil.getPosFromPosFacing(this.field_174879_c, this.orientation)))) {
                return;
            }
            block21: for (int j = 0; j <= 16; ++j) {
                int z;
                int y;
                int x;
                int[] rotatedCoords;
                int c;
                int b;
                int i;
                if (j <= 8) {
                    for (i = 1; i <= ConfigHandler.rangeConeFloodlight / 4; ++i) {
                        b = 0;
                        c = 0;
                        switch (j) {
                            case 0: {
                                b += i;
                                break;
                            }
                            case 1: {
                                b -= i;
                                break;
                            }
                            case 2: {
                                c += i;
                                break;
                            }
                            case 3: {
                                c -= i;
                                break;
                            }
                            case 4: {
                                b += i;
                                c += i;
                                break;
                            }
                            case 5: {
                                b += i;
                                c -= i;
                                break;
                            }
                            case 6: {
                                b -= i;
                                c += i;
                                break;
                            }
                            case 7: {
                                b -= i;
                                c -= i;
                            }
                        }
                        rotatedCoords = MathUtil.rotate(i, b, c, this.orientation);
                        x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                        y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                        z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                        this.setSource(new BlockPos(x, y, z), remove, k);
                        if (!this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x, y, z))) || remove) continue;
                        if (i >= 4) continue block21;
                        failedBeams[j] = true;
                        continue block21;
                    }
                    continue;
                }
                if (failedBeams[j - 9] && !remove) continue;
                for (i = 4; i <= ConfigHandler.rangeConeFloodlight / 4; ++i) {
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 9: {
                            b += i / 2;
                            break;
                        }
                        case 10: {
                            b -= i / 2;
                            break;
                        }
                        case 11: {
                            c += i / 2;
                            break;
                        }
                        case 12: {
                            c -= i / 2;
                            break;
                        }
                        case 13: {
                            b += i / 2;
                            c += i / 2;
                            break;
                        }
                        case 14: {
                            b += i / 2;
                            c -= i / 2;
                            break;
                        }
                        case 15: {
                            b -= i / 2;
                            c += i / 2;
                            break;
                        }
                        case 16: {
                            b -= i / 2;
                            c -= i / 2;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(i, b, c, this.orientation);
                    x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                    y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                    z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                    this.setSource(new BlockPos(x, y, z), remove, k);
                    if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x, y, z))) && !remove) continue block21;
                }
            }
            --k;
        }
    }

    public void narrowConeSource(boolean remove) {
        int k;
        int n = k = remove ? 1 : 2;
        while (k >= 0) {
            boolean[] failedBeams = new boolean[9];
            block21: for (int j = 0; j <= 16; ++j) {
                int z;
                int y;
                int x;
                int[] rotatedCoords;
                int c;
                int b;
                int a;
                int i;
                if (j <= 8) {
                    for (i = 1; i <= ConfigHandler.rangeConeFloodlight; ++i) {
                        if (i == 1) {
                            int x2 = this.field_174879_c.func_177958_n() + this.orientation.func_82601_c();
                            int y2 = this.field_174879_c.func_177956_o() + this.orientation.func_96559_d();
                            int z2 = this.field_174879_c.func_177952_p() + this.orientation.func_82599_e();
                            this.setSource(new BlockPos(x2, y2, z2), remove, k);
                            if (this.field_145850_b.func_180495_p(new BlockPos(x2, y2, z2)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x2, y2, z2))) && !remove) {
                                return;
                            }
                        }
                        a = i;
                        b = 0;
                        c = 0;
                        switch (j) {
                            case 0: {
                                b += i / 2;
                                break;
                            }
                            case 1: {
                                b -= i / 2;
                                break;
                            }
                            case 2: {
                                c += i / 2;
                                break;
                            }
                            case 3: {
                                c -= i / 2;
                                break;
                            }
                            case 4: {
                                b += i / 2;
                                c += i / 2;
                                break;
                            }
                            case 5: {
                                b += i / 2;
                                c -= i / 2;
                                break;
                            }
                            case 6: {
                                b -= i / 2;
                                c += i / 2;
                                break;
                            }
                            case 7: {
                                b -= i / 2;
                                c -= i / 2;
                            }
                        }
                        rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
                        x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                        y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                        z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                        this.setSource(new BlockPos(x, y, z), remove, k);
                        if (!this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x, y, z))) || remove) continue;
                        if (i >= 8) continue block21;
                        failedBeams[j] = true;
                        continue block21;
                    }
                    continue;
                }
                if (failedBeams[j - 9] && !remove) continue;
                for (i = 8; i <= ConfigHandler.rangeConeFloodlight; ++i) {
                    a = i;
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 9: {
                            b += i / 4;
                            break;
                        }
                        case 10: {
                            b -= i / 4;
                            break;
                        }
                        case 11: {
                            c += i / 4;
                            break;
                        }
                        case 12: {
                            c -= i / 4;
                            break;
                        }
                        case 13: {
                            b += i / 4;
                            c += i / 4;
                            break;
                        }
                        case 14: {
                            b += i / 4;
                            c -= i / 4;
                            break;
                        }
                        case 15: {
                            b -= i / 4;
                            c += i / 4;
                            break;
                        }
                        case 16: {
                            b -= i / 4;
                            c -= i / 4;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
                    x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                    y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                    z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                    this.setSource(new BlockPos(x, y, z), remove, k);
                    if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149662_c(this.field_145850_b.func_180495_p(new BlockPos(x, y, z))) && !remove) continue block21;
                }
            }
            --k;
        }
    }
}

