/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.block.BlockPhantomLight;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import de.keridos.floodlights.util.RandomUtil;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityGrowLight
extends TileEntityFLElectric {
    private long nextGrowTick = 0L;

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from.func_176734_d().ordinal() == this.orientation.ordinal();
    }

    public void growSource(boolean remove) {
        int[] rotatedCoords = MathUtil.rotate(1, 0, 0, this.orientation);
        int x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
        int y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
        int z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
        BlockPos blockPos = new BlockPos(x, y, z);
        if (remove) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight) {
                TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(blockPos);
                light.removeSource(this.field_174879_c);
            }
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c().isAir(this.field_145850_b.func_180495_p(blockPos), (IBlockAccess)this.field_145850_b, blockPos)) {
            this.setLight(blockPos);
            this.field_145850_b.func_175656_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(false)));
        } else if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() == ModBlocks.blockPhantomLight) {
            TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(blockPos);
            light.addSource(this.field_174879_c);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsageGrowLight;
            this.tryDischargeItem(this.inventory[0]);
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (world.func_72820_D() > this.nextGrowTick) {
                    BlockPos blockPosTarget = new BlockPos(this.field_174879_c.func_177958_n() + this.orientation.func_82601_c() * 2, this.field_174879_c.func_177956_o() + this.orientation.func_96559_d() * 2, this.field_174879_c.func_177952_p() + this.orientation.func_82599_e() * 2);
                    BlockPos blockPosFront = new BlockPos(this.field_174879_c.func_177958_n() + this.orientation.func_82601_c(), this.field_174879_c.func_177956_o() + this.orientation.func_96559_d(), this.field_174879_c.func_177952_p() + this.orientation.func_82599_e());
                    Block block = this.field_145850_b.func_180495_p(blockPosTarget).func_177230_c();
                    Block blockFront = this.field_145850_b.func_180495_p(blockPosFront).func_177230_c();
                    if (GeneralUtil.isBlockValidGrowable(block, world, blockPosTarget) && blockFront.isAir(this.field_145850_b.func_180495_p(blockPosFront), (IBlockAccess)world, blockPosFront)) {
                        ((IGrowable)block).func_176474_b(world, RandomUtil.random, blockPosTarget, world.func_180495_p(blockPosTarget));
                    }
                    this.nextGrowTick = world.func_72820_D() + (long)RandomUtil.getRandomTickTimeoutFromFloatChance(ConfigHandler.chanceGrowLight);
                }
                if (this.update) {
                    if (this.mode == 0) {
                        this.growSource(true);
                        this.growSource(false);
                    }
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                    this.update = false;
                } else if (!this.wasActive) {
                    if (this.mode == 0) {
                        this.growSource(false);
                    }
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                if (this.mode == 0) {
                    this.growSource(true);
                }
                world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
                world.func_72975_g(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.mode == 0) {
                this.growSource(true);
            }
            int n = this.mode = this.mode == 1 ? 0 : this.mode + 1;
            if (this.active && (this.storage.getEnergyStored() >= ConfigHandler.energyUsage || this.storageEU >= (double)ConfigHandler.energyUsage / 8.0) && this.mode == 0) {
                this.growSource(false);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:growLightLighting" : "gui.floodlights:growLightDarkLight";
            player.func_145747_a((ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

