/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="gregtech.api.interfaces.tileentity.IEnergyConnected", modid="GregTech")})
public class TileEntityFLElectric
extends TileEntityMetaFloodlight
implements IEnergyHandler,
IEnergyReceiver,
IEnergySink {
    protected boolean wasAddedToEnergyNet = false;
    protected double storageEU;
    protected EnergyStorage storage = new EnergyStorage(50000);

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("storageEU")) {
            this.storageEU = nbtTagCompound.func_74769_h("storageEU");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        this.storage.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74780_a("storageEU", this.storageEU);
        return nbtTagCompound;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return this.storage.getMaxEnergyStored();
    }

    public void setEnergyStored(int energyStored) {
        this.storage.setEnergyStored(energyStored);
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing forgeDirection, double v, double v1) {
        if ((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) >= v * 8.0) {
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 8.0));
        } else {
            this.storageEU += v - (double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) / 8.0;
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 8.0));
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return Math.max(4000.0 - this.storageEU, 0.0);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing forgeDirection) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="IC2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileUnloadEvent event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtil.isItemStackValidElectrical(itemstack);
    }

    @Override
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing facing) {
        return GeneralUtil.isItemStackValidElectrical(itemstack);
    }

    protected void tryDischargeItem(ItemStack itemStack) {
        if (itemStack != null) {
            if (ModCompatibility.IC2Loaded && this.inventory[0].func_77973_b() instanceof IElectricItem) {
                double dischargeValue = ((double)this.storage.getMaxEnergyStored() - (double)this.storage.getEnergyStored()) / 8.0;
                this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(8.0 * ElectricItem.manager.discharge(this.inventory[0], dischargeValue, 4, false, true, false)));
            }
            if (itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)itemStack.func_77973_b();
                int dischargeValue = Math.min(item.getEnergyStored(itemStack), this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
                this.storage.modifyEnergyStored(item.extractEnergy(itemStack, dischargeValue, false));
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (ModCompatibility.IC2Loaded && !this.wasAddedToEnergyNet && !this.field_145850_b.field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (!this.field_145850_b.field_72995_K && this.storageEU > 0.0 && this.storage.getEnergyStored() < 50000) {
            if (this.storageEU > (double)(this.storage.getEnergyStored() - 50000) / 8.0) {
                this.storageEU -= (double)(this.storage.getEnergyStored() - 50000) / 8.0;
                this.storage.setEnergyStored(50000);
            } else {
                this.storageEU = 0.0;
                this.storage.modifyEnergyStored(MathUtil.roundDoubleToInt(this.storageEU * 8.0));
            }
        }
    }
}

