/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.util.GeneralUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileEntityElectricFloodlight
extends TileEntityFLElectric
implements ISidedInventory {
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsage * (this.mode == 0 ? 1 : 4);
            this.tryDischargeItem(this.inventory[0]);
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (this.update) {
                    this.removeSource(this.mode);
                    this.addSource(this.mode);
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    this.update = false;
                } else if (!this.wasActive) {
                    this.addSource(this.mode);
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                this.removeSource(this.mode);
                world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177230_c().func_176203_a(this.getOrientation().ordinal()), 2);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void addSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(false);
        } else if (mode == 1) {
            this.narrowConeSource(false);
        } else if (mode == 2) {
            this.wideConeSource(false);
        }
    }

    public void removeSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(true);
        } else if (mode == 1) {
            this.narrowConeSource(true);
        } else if (mode == 2) {
            this.wideConeSource(true);
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsage * (this.mode == 0 ? 1 : 4);
            this.removeSource(this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                this.addSource(this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

