/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import java.util.logging.Logger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileEntityCarbonFloodlight
extends TileEntityMetaFloodlight {
    public int timeRemaining = 0;

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("timeRemaining")) {
            this.timeRemaining = nbtTagCompound.func_74762_e("timeRemaining");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("timeRemaining", this.timeRemaining);
        return nbtTagCompound;
    }

    @Override
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing facing) {
        return i == 0 && GeneralUtil.getBurnTime(itemstack) > 0;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtil.getBurnTime(itemstack) > 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.timeRemaining == 0 && this.inventory[0] != null) {
                this.timeRemaining = ConfigHandler.carbonTime * GeneralUtil.getBurnTime(this.inventory[0]) / 1600 * (this.mode == 0 ? 20 : 10);
                this.func_70298_a(0, 1);
            }
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && this.timeRemaining > 0) {
                if (this.update) {
                    this.removeSource(this.mode);
                    this.addSource(this.mode);
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                    this.update = false;
                } else if (!this.wasActive) {
                    this.addSource(this.mode);
                    Logger.getGlobal().info("rotation: " + this.orientation.toString());
                    world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                }
                --this.timeRemaining;
                this.wasActive = true;
            } else if (this.wasActive) {
                this.removeSource(this.mode);
                world.func_180501_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFLColorableMachine.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void addSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(false);
        } else if (mode == 1) {
            this.narrowConeSource(false);
        } else if (mode == 2) {
            this.wideConeSource(false);
        }
    }

    public void removeSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(true);
        } else if (mode == 1) {
            this.narrowConeSource(true);
        } else if (mode == 2) {
            this.wideConeSource(true);
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            this.removeSource(this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.mode == 1) {
                this.timeRemaining /= 4;
            } else if (this.mode == 0) {
                this.timeRemaining *= 4;
            }
            if (this.active && this.timeRemaining > 0) {
                this.addSource(this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

