/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.core.proxy;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.block.BlockPhantomLight;
import de.keridos.floodlights.block.BlockSmallElectricFloodlight;
import de.keridos.floodlights.client.render.block.TileEntityPhantomLightRenderer;
import de.keridos.floodlights.compatability.IGWHandler;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.core.proxy.CommonProxy;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.init.ModItems;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.RenderUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
extends CommonProxy {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString().toLowerCase()));
    }

    public void registerItemModel(Item item, int meta, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString().toLowerCase()), variantName));
    }

    public void registerBlockModelAsItem(Block block, int meta, String blockName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("FloodLights".toLowerCase() + ":" + blockName, "inventory"));
    }

    public void registerBlockModelAsItem(Block block, int meta, String blockName, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("FloodLights".toLowerCase() + ":" + blockName, variantName));
    }

    @Override
    public void initRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPhantomLight.class, (TileEntitySpecialRenderer)new TileEntityPhantomLightRenderer());
        RenderUtil.setupColors();
        minecraft.func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int renderPass) {
                return RenderUtil.getColorAsInt((Integer)state.func_177229_b((IProperty)BlockFLColorableMachine.COLOR));
            }
        }, new Block[]{ModBlocks.blockCarbonLight, ModBlocks.blockElectricLight, ModBlocks.blockSmallElectricLight});
    }

    @Override
    public void preInit() {
        this.registerBlockModelAsItem(ModBlocks.blockElectricLight, 0, "electricFloodlight");
        this.registerBlockModelAsItem(ModBlocks.blockCarbonLight, 0, "carbonFloodlight");
        this.registerBlockModelAsItem(ModBlocks.blockUVLight, 0, "uvFloodlight");
        this.registerBlockModelAsItem(ModBlocks.blockGrowLight, 0, "growLight");
        this.registerBlockModelAsItem(ModBlocks.blockSmallElectricLight, 0, "smallElectricFloodlightMetaBlock", "inventory_strip");
        this.registerBlockModelAsItem(ModBlocks.blockSmallElectricLight, 1, "smallElectricFloodlightMetaBlock", "inventory_square");
        this.registerItemModel(ModItems.carbonDissolver, 0);
        this.registerItemModel(ModItems.carbonLantern, 0);
        this.registerItemModel(ModItems.glowingFilament, 0);
        this.registerItemModel(ModItems.lightBulb, 0);
        this.registerItemModel(ModItems.lightDebugTool, 0);
        this.registerItemModel(ModItems.mantle, 0);
        this.registerItemModel(ModItems.rawFilament, 0);
        StateMap ignoreColor = new StateMap.Builder().func_178442_a(new IProperty[]{BlockFLColorableMachine.COLOR}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockCarbonLight, (IStateMapper)ignoreColor);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockElectricLight, (IStateMapper)ignoreColor);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockUVLight, (IStateMapper)ignoreColor);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockSmallElectricLight, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockSmallElectricFloodlight.MODEL).func_178442_a(new IProperty[]{BlockFLColorableMachine.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockGrowLight, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFLColorableMachine.COLOR}).func_178442_a(new IProperty[]{BlockFLColorableMachine.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockPhantomLight, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockPhantomLight.UPDATE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockUVLightBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockPhantomLight.UPDATE}).func_178441_a());
    }

    @Override
    public void initSounds() {
    }

    @Override
    public void initHandlers() {
        if (ModCompatibility.IGWModLoaded) {
            ModCompatibility.getInstance().igwHandler = IGWHandler.getInstance();
        }
    }
}

