/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.core.network.message;

import de.keridos.floodlights.tileentity.TileEntityCarbonFloodlight;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTileEntityFL
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int timeRemaining;
    public int color;
    public int rfStorage;
    public byte orientation;
    public byte state;
    public boolean rotationState;
    public boolean wasActive;
    public String customName;
    public String owner;

    public MessageTileEntityFL() {
    }

    public MessageTileEntityFL(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityFL) {
            TileEntityFL tileEntityFL = (TileEntityFL)tileEntity;
            this.x = tileEntityFL.func_174877_v().func_177958_n();
            this.y = tileEntityFL.func_174877_v().func_177956_o();
            this.z = tileEntityFL.func_174877_v().func_177952_p();
            this.orientation = (byte)tileEntityFL.getOrientation().ordinal();
            this.state = (byte)tileEntityFL.getState();
            this.customName = tileEntityFL.getCustomName();
            this.owner = tileEntityFL.getOwner();
            this.color = tileEntityFL.getColor();
            this.timeRemaining = tileEntity instanceof TileEntityCarbonFloodlight ? ((TileEntityCarbonFloodlight)tileEntity).timeRemaining : 0;
            this.rotationState = tileEntity instanceof TileEntitySmallFloodlight ? ((TileEntitySmallFloodlight)tileEntity).getRotationState() : false;
            this.rfStorage = tileEntity instanceof TileEntityFLElectric ? ((TileEntityFLElectric)tileEntity).getEnergyStored(EnumFacing.UP) : 0;
            this.wasActive = tileEntity instanceof TileEntityMetaFloodlight ? ((TileEntityMetaFloodlight)tileEntity).getWasActive() : false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.timeRemaining = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        int ownerLength = buf.readInt();
        this.owner = new String(buf.readBytes(ownerLength).array());
        this.rotationState = buf.readBoolean();
        this.color = buf.readInt();
        this.rfStorage = buf.readInt();
        this.wasActive = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.timeRemaining);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        buf.writeInt(this.owner.length());
        buf.writeBytes(this.owner.getBytes());
        buf.writeBoolean(this.rotationState);
        buf.writeInt(this.color);
        buf.writeInt(this.rfStorage);
        buf.writeBoolean(this.wasActive);
    }

    public String toString() {
        return String.format("MessageTileEntityFL - x:%s, y:%s, z:%s, timeRemaining:%s, orientation:%s, state:%s, customName:%s, owner:%s", this.x, this.y, this.z, this.timeRemaining, this.orientation, this.state, this.customName, this.owner);
    }

    public static class MessageTileEntityFLHandler
    implements IMessageHandler<MessageTileEntityFL, IMessage> {
        public IMessage onMessage(MessageTileEntityFL messagein, MessageContext ctx) {
            final MessageTileEntityFL message = messagein;
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
                    if (tileEntity instanceof TileEntityFL) {
                        ((TileEntityFL)tileEntity).setOrientation(message.orientation);
                        ((TileEntityFL)tileEntity).setState(message.state);
                        ((TileEntityFL)tileEntity).setCustomName(message.customName);
                        ((TileEntityFL)tileEntity).setOwner(message.owner);
                        ((TileEntityFL)tileEntity).setColor(message.color);
                    }
                    if (tileEntity instanceof TileEntityCarbonFloodlight) {
                        ((TileEntityCarbonFloodlight)tileEntity).timeRemaining = message.timeRemaining;
                    }
                    if (tileEntity instanceof TileEntitySmallFloodlight) {
                        ((TileEntitySmallFloodlight)tileEntity).setRotationState(message.rotationState);
                    }
                    if (tileEntity instanceof TileEntityFLElectric) {
                        ((TileEntityFLElectric)tileEntity).setEnergyStored(message.rfStorage);
                    }
                    if (tileEntity instanceof TileEntityMetaFloodlight) {
                        ((TileEntityMetaFloodlight)tileEntity).setWasActive(message.wasActive);
                    }
                }
            });
            return null;
        }
    }
}

