/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.compatability;

import crazypants.enderio.api.tool.ITool;
import de.keridos.floodlights.compatability.IGWHandler;
import de.keridos.floodlights.compatability.IGWSupportNotifier;
import de.keridos.floodlights.handler.ConfigHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ModCompatibility {
    private static ModCompatibility instance = null;
    public IGWHandler igwHandler = null;
    public static boolean IC2Loaded = false;
    public static boolean IGWModLoaded = false;
    public static boolean BCLoaded = false;
    public static boolean CofhCoreLoaded = false;
    public static boolean NEILoaded = false;
    public static boolean JEILoaded = false;
    public static boolean EnderIOLoaded = false;
    public static boolean WrenchAvailable = false;
    public static boolean ColoredLightCoreLoaded = false;
    public static boolean ACLoaded = false;

    private ModCompatibility() {
    }

    public static ModCompatibility getInstance() {
        if (instance == null) {
            instance = new ModCompatibility();
        }
        return instance;
    }

    private void checkForMods() {
        IC2Loaded = Loader.isModLoaded((String)"IC2");
        IGWModLoaded = Loader.isModLoaded((String)"IGWMod");
        BCLoaded = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools");
        CofhCoreLoaded = ModAPIManager.INSTANCE.hasAPI("CoFHAPI|item");
        NEILoaded = Loader.isModLoaded((String)"NotEnoughItems");
        JEILoaded = Loader.isModLoaded((String)"JEI");
        EnderIOLoaded = Loader.isModLoaded((String)"EnderIO");
        ColoredLightCoreLoaded = Loader.isModLoaded((String)"coloredlightcore");
        ACLoaded = Loader.isModLoaded((String)"AgriCraft");
    }

    @Optional.Method(modid="NotEnoughItems")
    private void hideNEIItems() {
    }

    private void addVersionCheckerInfo() {
        NBTTagCompound versionchecker = new NBTTagCompound();
        versionchecker.func_74778_a("curseProjectName", "224728-floodlights");
        versionchecker.func_74778_a("curseFilenameParser", "FloodLights-@MCVERSION@-[]");
        versionchecker.func_74778_a("modDisplayName", "FloodLights");
        versionchecker.func_74778_a("oldVersion", "1.2.7-145");
        FMLInterModComms.sendRuntimeMessage((Object)"floodlights", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)versionchecker);
    }

    public void performModCompat() {
        this.checkForMods();
        if (ConfigHandler.IGWNotifierEnabled) {
            new IGWSupportNotifier();
        }
        if (NEILoaded) {
            this.hideNEIItems();
        }
        this.addVersionCheckerInfo();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"de.keridos.floodlights.compatability.WailaTileHandler.callbackRegister");
        WrenchAvailable = BCLoaded || EnderIOLoaded || IC2Loaded || CofhCoreLoaded;
    }

    public boolean isItemValidWrench(ItemStack stack) {
        if (EnderIOLoaded && stack.func_77973_b() instanceof ITool) {
            return true;
        }
        if (IC2Loaded) {
            if (stack.func_77973_b().func_77658_a().equals("ic2.itemToolWrench")) {
                return true;
            }
            if (stack.func_77973_b().func_77658_a().equals("ic2.itemToolWrenchElectric")) {
                return true;
            }
        }
        return false;
    }
}

