/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.FloodLights;
import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import de.keridos.floodlights.util.PropertiesEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSmallElectricFloodlight
extends BlockFLColorableMachine
implements ITileEntityProvider {
    public static final PropertyBool ROTATIONSTATE = PropertyBool.func_177716_a((String)"rotationstate");
    public static final PropertyEnum MODEL = PropertyEnum.func_177709_a((String)"model", PropertiesEnum.EnumModelSmallLight.class);

    public BlockSmallElectricFloodlight() {
        super("smallElectricFloodlightMetaBlock", Material.field_151576_e, SoundType.field_185852_e, 2.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)MODEL, (Comparable)((Object)PropertiesEnum.EnumModelSmallLight.values()[0])).func_177226_a((IProperty)ROTATIONSTATE, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)((Object)PropertiesEnum.EnumModelSmallLight.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((PropertiesEnum.EnumModelSmallLight)((Object)state.func_177229_b((IProperty)MODEL))).getID();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntitySmallFloodlight) {
            TileEntitySmallFloodlight te = (TileEntitySmallFloodlight)worldIn.func_175625_s(pos);
            return state.func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(te.getColor())).func_177226_a((IProperty)FACING, (Comparable)te.getOrientation()).func_177226_a((IProperty)ROTATIONSTATE, (Comparable)Boolean.valueOf(te.getRotationState())).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(te.getWasActive()));
        }
        return state.func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(16));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, COLOR, ROTATIONSTATE, MODEL});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K && heldItem == null && player.func_70093_af()) {
                ((TileEntitySmallFloodlight)world.func_175625_s(pos)).toggleInverted();
                String invert = ((TileEntitySmallFloodlight)world.func_175625_s(pos)).getInverted() ? "gui.floodlights:true" : "gui.floodlights:false";
                player.func_145747_a((ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("gui.floodlights:invert") + ": " + GeneralUtil.safeLocalize(invert)));
                return true;
            }
            if (!world.field_72995_K && heldItem != null) {
                if (!ModCompatibility.WrenchAvailable && heldItem.func_77973_b() == GeneralUtil.getMinecraftItem("stick")) {
                    ((TileEntitySmallFloodlight)world.func_175625_s(pos)).toggleRotationState();
                    return true;
                }
                if (player.func_70093_af() && ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                    world.func_175655_b(pos, true);
                    return true;
                }
                if (ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                    ((TileEntitySmallFloodlight)world.func_175625_s(pos)).toggleRotationState();
                    return true;
                }
                if (heldItem.func_77973_b() == Items.field_151100_aR) {
                    ((TileEntityFL)world.func_175625_s(pos)).setColor(15 - heldItem.func_77952_i());
                    return true;
                }
            }
            if (!world.field_72995_K) {
                player.openGui((Object)FloodLights.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            return true;
        }
        return true;
    }

    public TileEntitySmallFloodlight createNewTileEntity(World world, int metadata) {
        return new TileEntitySmallFloodlight();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntitySmallFloodlight) {
            TileEntitySmallFloodlight tileEntitySmallFloodlight = (TileEntitySmallFloodlight)world.func_175625_s(pos);
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            switch (this.func_176201_c(world.func_180495_p(pos))) {
                case 0: {
                    if (!tileEntitySmallFloodlight.getRotationState()) {
                        minX = 0.0;
                        maxX = 0.1875;
                        minY = 0.3125;
                        maxY = 0.6875;
                        minZ = 0.0;
                        maxZ = 1.0;
                        break;
                    }
                    minX = 0.0;
                    maxX = 0.1875;
                    minY = 0.0;
                    maxY = 1.0;
                    minZ = 0.3125;
                    maxZ = 0.6875;
                    break;
                }
                case 1: {
                    minX = 0.0;
                    maxX = 0.1875;
                    minY = 0.0;
                    maxY = 1.0;
                    minZ = 0.0;
                    maxZ = 1.0;
                }
            }
            double[] newMinTemp = MathUtil.rotateD(minX -= 0.5, minY -= 0.5, minZ -= 0.5, tileEntitySmallFloodlight.getOrientation());
            double[] newMaxTemp = MathUtil.rotateD(maxX -= 0.5, maxY -= 0.5, maxZ -= 0.5, tileEntitySmallFloodlight.getOrientation());
            double[] newMax = MathUtil.sortMinMaxToMax(newMinTemp, newMaxTemp);
            double[] newMin = MathUtil.sortMinMaxToMin(newMinTemp, newMaxTemp);
            minX = newMin[0] + 0.5;
            minY = newMin[1] + 0.5;
            minZ = newMin[2] + 0.5;
            maxX = newMax[0] + 0.5;
            maxY = newMax[1] + 0.5;
            maxZ = newMax[2] + 0.5;
            return new AxisAlignedBB((double)pos.func_177958_n() + minX, (double)pos.func_177956_o() + minY, (double)pos.func_177952_p() + minZ, (double)pos.func_177958_n() + maxX, (double)pos.func_177956_o() + maxY, (double)pos.func_177952_p() + maxZ);
        }
        return super.func_180640_a(state, world, pos);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        ((TileEntitySmallFloodlight)world.func_175625_s(pos)).smallSource(true);
        super.func_180663_b(world, pos, blockState);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.func_175625_s(pos) instanceof TileEntityFL) {
            if (stack.func_82837_s()) {
                ((TileEntityFL)world.func_175625_s(pos)).setCustomName(stack.func_82833_r());
            }
            ((TileEntityFL)world.func_175625_s(pos)).setOrientation(this.getFacing(placer));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(0, new ItemStack(ModBlocks.blockSmallElectricLight, 1, this.func_176201_c(state)));
        return drops;
    }

    public int func_180651_a(IBlockState state) {
        return super.func_180651_a(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 2; ++i) {
            subItems.add(new ItemStack(ModBlocks.blockSmallElectricLight, 1, i));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

