/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.FloodLights;
import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityGrowLight;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrowLight
extends BlockFLColorableMachine {
    public BlockGrowLight() {
        super("growLight", Material.field_151576_e, SoundType.field_185852_e, 2.5f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntitySmallFloodlight) {
            TileEntitySmallFloodlight te = (TileEntitySmallFloodlight)worldIn.func_175625_s(pos);
            return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(te.getWasActive()));
        }
        return state.func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(16));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K && heldItem == null && player.func_70093_af()) {
                ((TileEntityMetaFloodlight)world.func_175625_s(pos)).toggleInverted();
                String invert = ((TileEntityMetaFloodlight)world.func_175625_s(pos)).getInverted() ? "gui.floodlights:true" : "gui.floodlights:false";
                player.func_145747_a((ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("gui.floodlights:invert") + ": " + GeneralUtil.safeLocalize(invert)));
                return true;
            }
            if (!world.field_72995_K && heldItem != null) {
                if (!ModCompatibility.WrenchAvailable && heldItem.func_77973_b() == GeneralUtil.getMinecraftItem("stick")) {
                    ((TileEntityGrowLight)world.func_175625_s(pos)).changeMode(player);
                    return true;
                }
                if (player.func_70093_af() && ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                    world.func_175655_b(pos, true);
                    return true;
                }
                if (ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                    ((TileEntityGrowLight)world.func_175625_s(pos)).changeMode(player);
                    return true;
                }
                if (heldItem.func_77973_b() == Items.field_151100_aR) {
                    ((TileEntityFL)world.func_175625_s(pos)).setColor(15 - heldItem.func_77952_i());
                    return true;
                }
            }
            if (!world.field_72995_K) {
                player.openGui((Object)FloodLights.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            return true;
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World w, @Nonnull IBlockState state) {
        return new TileEntityGrowLight();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        double minX = 0.0;
        double minY = 0.8125;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        return new AxisAlignedBB((double)pos.func_177958_n() + minX, (double)pos.func_177956_o() + minY, (double)pos.func_177952_p() + minZ, (double)pos.func_177958_n() + maxX, (double)pos.func_177956_o() + maxY, (double)pos.func_177952_p() + maxZ);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        ((TileEntityGrowLight)world.func_175625_s(pos)).growSource(true);
        super.func_180663_b(world, pos, blockState);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.func_175625_s(pos) instanceof TileEntityFL) {
            if (stack.func_82837_s()) {
                ((TileEntityFL)world.func_175625_s(pos)).setCustomName(stack.func_82833_r());
            }
            ((TileEntityFL)world.func_175625_s(pos)).setOrientation(EnumFacing.DOWN);
        }
    }
}

