/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.client.gui.CreativeTabFloodlight;
import de.keridos.floodlights.reference.Textures;
import de.keridos.floodlights.tileentity.TileEntityFL;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockFL
extends Block {
    protected String unlocName;

    protected BlockFL(String unlocName, Material material, SoundType type, float hardness) {
        super(material);
        this.func_149711_c(hardness);
        this.func_149663_c(unlocName);
        this.unlocName = unlocName;
        if (!unlocName.equals("tilePhantomLight") && !unlocName.equals("tileUVLight")) {
            this.func_149647_a(CreativeTabFloodlight.FL_TAB);
        }
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        this.dropInventory(world, pos);
        super.func_180663_b(world, pos, blockState);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityFL) {
            if (stack.func_82837_s()) {
                ((TileEntityFL)world.func_175625_s(pos)).setCustomName(stack.func_82833_r());
            }
            ((TileEntityFL)world.func_175625_s(pos)).setOrientation(this.getFacing(placer));
            world.func_180501_a(pos, this.func_176203_a(this.getFacing(placer).ordinal()), 2);
        }
    }

    protected void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    public EnumFacing getFacing(EntityLivingBase entityLiving) {
        float rotationYaw = MathHelper.func_76142_g((float)entityLiving.field_70177_z);
        float rotationPitch = entityLiving.field_70125_A;
        int result = rotationPitch < -45.0f ? 1 : (rotationPitch > 45.0f ? 0 : (MathHelper.func_76128_c((double)((double)(rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) + 2);
        EnumFacing[] direction = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
        return direction[result];
    }
}

