/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.ICentralInventory;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.core.BDLogger;
import mods.belgabor.bitdrawers.core.BitHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BitDrawerData
extends BaseDrawerData
implements IFractionalDrawer,
IVoidable,
IShroudable,
IItemLockable {
    private static final ItemStack nullStack = new ItemStack((Item)null);
    private ICentralInventory central;
    private int slot;

    public BitDrawerData(ICentralInventory centralInventory, int slot) {
        this.slot = slot;
        this.central = centralInventory;
    }

    public ItemStack getStoredItemPrototype() {
        return this.central.getStoredItemPrototype(this.slot);
    }

    public void setStoredItem(ItemStack itemPrototype, int amount) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("setStoredItem %d %s %d", this.slot, itemPrototype == null ? "null" : itemPrototype.func_82833_r(), amount);
        }
        this.central.setStoredItem(this.slot, itemPrototype, amount);
        this.refresh();
    }

    public IDrawer setStoredItemRedir(ItemStack itemPrototype, int amount) {
        IDrawer target = this.central.setStoredItem(this.slot, itemPrototype, amount);
        this.refresh();
        return target;
    }

    public boolean areItemsEqual(ItemStack item) {
        ItemStack protoStack = this.getStoredItemPrototype();
        return BitHelper.areItemsEqual(item, protoStack);
    }

    public int getStoredItemCount() {
        return this.central.getStoredItemCount(this.slot);
    }

    public void setStoredItemCount(int amount) {
        this.central.setStoredItemCount(this.slot, amount);
    }

    public int getMaxCapacity() {
        return this.central.getMaxCapacity(this.slot);
    }

    public int getMaxCapacity(ItemStack itemPrototype) {
        return this.central.getMaxCapacity(this.slot, itemPrototype);
    }

    public int getRemainingCapacity() {
        return this.central.getRemainingCapacity(this.slot);
    }

    public int getStoredItemStackSize() {
        return this.central.getStoredItemStackSize(this.slot);
    }

    protected int getItemCapacityForInventoryStack() {
        return this.central.getItemCapacityForInventoryStack(this.slot);
    }

    public boolean canItemBeStored(ItemStack itemPrototype) {
        if (this.getStoredItemPrototype() == null && !this.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            return BitHelper.getBit(itemPrototype) != null || BitHelper.getBlock(itemPrototype) != null;
        }
        return this.areItemsEqual(itemPrototype);
    }

    public boolean canItemBeExtracted(ItemStack itemPrototype) {
        return this.areItemsEqual(itemPrototype);
    }

    public boolean isEmpty() {
        return this.getStoredItemPrototype() == null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.central.writeToNBT(this.slot, tag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.central.readFromNBT(this.slot, tag);
        this.refresh();
    }

    public int getConversionRate() {
        return this.central.getConversionRate(this.slot);
    }

    public int getStoredItemRemainder() {
        return this.central.getStoredItemRemainder(this.slot);
    }

    public boolean isSmallestUnit() {
        return this.central.isSmallestUnit(this.slot);
    }

    public void refresh() {
        this.reset();
        this.refreshOreDictMatches();
    }

    public boolean isVoid() {
        return this.central.isVoidSlot(this.slot);
    }

    public boolean isShrouded() {
        return this.central.isShroudedSlot(this.slot);
    }

    public boolean setIsShrouded(boolean state) {
        return this.central.setIsSlotShrouded(this.slot, state);
    }

    public boolean isItemLocked(LockAttribute attr) {
        return this.central.isLocked(this.slot, attr);
    }

    public boolean canItemLock(LockAttribute attr) {
        return false;
    }

    public void setItemLocked(LockAttribute attr, boolean isLocked) {
    }
}

