/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerInventoryHelper;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.mojang.authlib.GameProfile;
import java.util.List;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.ItemType;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.block.tile.TileBitDrawers;
import mods.belgabor.bitdrawers.core.BDLogger;
import mods.belgabor.bitdrawers.core.BitHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBitDrawers
extends BlockDrawers
implements INetworked {
    public static final PropertyEnum SLOTS = PropertyEnum.func_177709_a((String)"slots", EnumCompDrawer.class);
    @SideOnly(value=Side.CLIENT)
    private StatusModelData statusInfo;

    public BlockBitDrawers(String blockName) {
        super(Material.field_151576_e, blockName);
        this.func_149672_a(SoundType.field_185851_d);
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SLOTS, (Comparable)EnumCompDrawer.OPEN1).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        ResourceLocation location = new ResourceLocation("bitdrawers:models/dynamic/bitDrawers.json");
        this.statusInfo = new StatusModelData(3, location);
    }

    public StatusModelData getStatusInfo(IBlockState state) {
        return this.statusInfo;
    }

    public int getDrawerCount(IBlockState state) {
        return 3;
    }

    public boolean isHalfDepth(IBlockState state) {
        return false;
    }

    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (this.hitTop(hitY)) {
            return 0;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return 1;
        }
        return 2;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public BlockType retrimType() {
        return null;
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileBitDrawers();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{SLOTS, FACING}, new IUnlistedProperty[]{STATE_MODEL});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)tile.getDirection());
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        EnumCompDrawer slots = EnumCompDrawer.OPEN1;
        if (tile.isDrawerEnabled(1)) {
            slots = EnumCompDrawer.OPEN2;
        }
        if (tile.isDrawerEnabled(2)) {
            slots = EnumCompDrawer.OPEN3;
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)SLOTS, (Comparable)slots);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && !tile.isSealed()) {
            for (int i = 0; i < tile.getUpgradeSlotCount(); ++i) {
                ItemStack stack = tile.getUpgrade(i);
                if (stack == null) continue;
                BlockBitDrawers.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            if (!tile.isVending()) {
                DrawerInventoryHelper.dropInventoryItems((World)world, (BlockPos)pos, (IDrawerGroup)tile);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K && BitDrawers.config.debugTrace) {
            BDLogger.info("BlockBitDrawers:onBlockClicked", new Object[0]);
        }
        super.func_180649_a(world, pos, player);
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ, boolean invertShift) {
        if (world.field_72995_K) {
            return;
        }
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("BlockBitDrawers:onBlockClicked %f %f %f", Float.valueOf(hitX), Float.valueOf(hitY), Float.valueOf(hitZ));
        }
        ((WorldServer)world).func_152344_a(() -> this.onBlockClickedAsync(world, pos, player, side, hitX, hitY, hitZ, invertShift));
    }

    protected void onBlockClickedAsync(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ, boolean invertShift) {
        ItemStack item;
        IItemHandler handler;
        TileEntityDrawers tileDrawers;
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("IExtendedBlockClickHandler.onBlockClicked", new Object[0]);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            PlayerInteractEvent.LeftClickBlock event = new PlayerInteractEvent.LeftClickBlock(player, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
        }
        if ((tileDrawers = this.getTileEntitySafe(world, pos)).getDirection() != side.ordinal()) {
            return;
        }
        if (tileDrawers.isSealed()) {
            return;
        }
        if (!SecurityManager.hasAccess((GameProfile)player.func_146103_bH(), (IProtectable)tileDrawers)) {
            return;
        }
        int slot = this.getDrawerSlot(this.getDrawerCount(world.func_180495_p(pos)), side.ordinal(), hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        ItemStack held = player.field_71071_by.func_70448_g();
        ItemType heldType = BitDrawers.cnb_api.getItemType(held);
        IItemHandler iItemHandler = handler = held == null ? null : (IItemHandler)held.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler instanceof IBitBag) {
            IBitBag bag = (IBitBag)handler;
            drawer = tileDrawers.getDrawer(1);
            if (drawer.getStoredItemPrototype() == null) {
                return;
            }
            int retrieved = 0;
            if (player.func_70093_af() != invertShift) {
                for (int i = 0; i < bag.getSlots(); ++i) {
                    ItemStack test = bag.getStackInSlot(i);
                    if (test != null && (test.field_77994_a >= bag.getBitbagStackSize() || !drawer.canItemBeExtracted(test))) continue;
                    int local = this.fillBagSlot(bag, i, drawer, tileDrawers);
                    if (local != 0) {
                        retrieved += local;
                        continue;
                    }
                    break;
                }
            } else {
                int addSlot = -1;
                for (int i = 0; i < bag.getSlots(); ++i) {
                    ItemStack test = bag.getStackInSlot(i);
                    if (test == null) {
                        if (addSlot != -1) continue;
                        addSlot = i;
                        continue;
                    }
                    if (test.field_77994_a >= bag.getBitbagStackSize() || !drawer.canItemBeExtracted(test)) continue;
                    addSlot = i;
                    break;
                }
                if (addSlot >= 0) {
                    retrieved = this.fillBagSlot(bag, addSlot, drawer, tileDrawers);
                }
            }
            if (retrieved > 0 && !world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            item = null;
        } else if (slot == 1 && heldType != null && heldType.isBitAccess) {
            IBitBrush brush;
            ItemStack bit = drawer.getStoredItemPrototype();
            if (bit == null) {
                return;
            }
            try {
                brush = BitDrawers.cnb_api.createBrush(bit);
            }
            catch (APIExceptions.InvalidBitItem e) {
                return;
            }
            item = BitHelper.getMonochrome(held, brush);
            if (item == null) {
                return;
            }
            int bitCount = item.field_77994_a;
            item.field_77994_a = player.func_70093_af() != invertShift ? 64 : 1;
            item.field_77994_a = Math.min(item.field_77994_a, drawer.getStoredItemCount() / bitCount);
            if (item.field_77994_a == 0) {
                return;
            }
            drawer.setStoredItemCount(drawer.getStoredItemCount() - item.field_77994_a * bitCount);
        } else {
            item = player.func_70093_af() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
            if (BitDrawers.config.debugTrace) {
                BDLogger.info(item == null ? "  null item" : "  " + item.toString(), new Object[0]);
            }
        }
        IBlockState state = world.func_180495_p(pos);
        if (item != null && item.field_77994_a > 0) {
            if (!player.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(world, pos.func_177972_a(side), player, item);
                world.func_184138_a(pos, state, state, 3);
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    protected void dropItemStack(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
        world.func_72838_d((Entity)entity);
    }

    protected int fillBagSlot(IBitBag bag, int slot, IDrawer drawer, TileEntityDrawers tileDrawers) {
        ItemStack temp;
        int toAdd = bag.getBitbagStackSize();
        ItemStack item = bag.getStackInSlot(slot);
        if (item != null) {
            toAdd -= item.field_77994_a;
        }
        item = drawer.getStoredItemPrototype().func_77946_l();
        item.field_77994_a = toAdd;
        ItemStack test = bag.insertItem(slot, item.func_77946_l(), true);
        if (test != null) {
            toAdd -= test.field_77994_a;
        }
        if (toAdd == 0) {
            return 0;
        }
        int retrieved = 0;
        while ((temp = tileDrawers.takeItemsFromSlot(1, toAdd)) != null && temp.field_77994_a != 0) {
            retrieved += temp.field_77994_a;
            if ((toAdd -= temp.field_77994_a) != 0) continue;
            break;
        }
        if (retrieved == 0) {
            return 0;
        }
        item.field_77994_a = retrieved;
        test = bag.insertItem(slot, item, false);
        if (test != null && test.field_77994_a != 0) {
            BDLogger.error("Could not insert simulated bit amount into bag. Something went very wrong.", new Object[0]);
        }
        return retrieved;
    }
}

