/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.IBlockDestroyHandler;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import com.jaquadro.minecraft.storagedrawers.network.BlockDestroyMessage;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.ItemType;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.block.tile.TileBitController;
import mods.belgabor.bitdrawers.core.BDLogger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBitController
extends BlockController
implements IExtendedBlockClickHandler,
IBlockDestroyHandler {
    public BlockBitController(String name) {
        super(name);
    }

    public TileBitController createNewTileEntity(World world, int meta) {
        return new TileBitController();
    }

    public EnumFacing getDirection(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.func_180495_p(pos);
        EnumFacing facing = state != null ? (EnumFacing)state.func_177229_b((IProperty)FACING) : EnumFacing.NORTH;
        return facing != null ? facing : EnumFacing.NORTH;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d) {
            if (world.field_72995_K) {
                RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
                if (this.getDirection((IBlockAccess)world, pos) == ray.field_178784_b) {
                    this.func_180649_a(world, pos, player);
                    if (BitDrawers.config.debugTrace) {
                        BDLogger.info("StorageDrawers", "BlockBitController.removedByPlayer with " + ray.toString());
                    }
                } else {
                    StorageDrawers.network.sendToServer((IMessage)new BlockDestroyMessage(pos));
                }
            }
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void onBlockDestroyed(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            ((WorldServer)world).func_152344_a(() -> this.onBlockDestroyedAsync(world, pos));
        }
    }

    private void onBlockDestroyedAsync(World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
            BlockPos posb = ray.func_178782_a();
            float hitX = (float)(ray.field_72307_f.field_72450_a - (double)posb.func_177958_n());
            float hitY = (float)(ray.field_72307_f.field_72448_b - (double)posb.func_177956_o());
            float hitZ = (float)(ray.field_72307_f.field_72449_c - (double)posb.func_177952_p());
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ray.field_178784_b.ordinal(), hitX, hitY, hitZ, StorageDrawers.config.cache.invertShift));
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("BlockBitController.onBlockClicked with " + ray.toString(), new Object[0]);
            }
        }
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ, boolean invertShift) {
        if (world.field_72995_K) {
            return;
        }
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("BlockBitController:onBlockClicked %f %f %f", Float.valueOf(hitX), Float.valueOf(hitY), Float.valueOf(hitZ));
        }
        ((WorldServer)world).func_152344_a(() -> this.onBlockClickedAsync(world, pos, player, side, hitX, hitY, hitZ, invertShift));
    }

    protected void onBlockClickedAsync(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ, boolean invertShift) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("IExtendedBlockClickHandler.onBlockClicked", new Object[0]);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            PlayerInteractEvent.LeftClickBlock event = new PlayerInteractEvent.LeftClickBlock(player, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
        }
        TileBitController tileDrawers = (TileBitController)this.getTileEntitySafe(world, pos);
        if (this.getDirection((IBlockAccess)world, pos).ordinal() != side.ordinal()) {
            return;
        }
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held == null && BitDrawers.config.debugTrace) {
            tileDrawers.updateCache();
        }
        ItemType heldType = BitDrawers.cnb_api.getItemType(held);
        IItemHandler handler = held == null ? null : (IItemHandler)held.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack item = null;
        if (handler instanceof IBitBag) {
            IBitBag bag = (IBitBag)handler;
            int retrieved = tileDrawers.fillBag(bag, player.func_146103_bH());
            if (retrieved > 0 && !world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            item = null;
        } else if (heldType != null && heldType.isBitAccess && heldType != ItemType.NEGATIVE_DESIGN) {
            item = tileDrawers.retrieveByPattern(held, player, player.func_70093_af() != invertShift);
        }
        IBlockState state = world.func_180495_p(pos);
        if (item != null && item.field_77994_a > 0) {
            if (!player.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(world, pos.func_177972_a(side), player, item);
                world.func_184138_a(pos, state, state, 3);
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    protected void dropItemStack(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
        world.func_72838_d((Entity)entity);
    }
}

