/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.block.BlockWirelessEndpoint;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityWirelessEndpoint;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityWirelessReceiver
extends TileEntityWirelessEndpoint {
    private UUID transmitter;
    private CoPoWorldData.Transmitter transmitterCache;
    private float syncedYaw;
    private float syncedPitch;

    public float getYaw(float partialTicks) {
        switch (this.getCurrentState()) {
            case ERROR: {
                return ((float)this.field_145850_b.func_82737_E() + partialTicks) % 360.0f;
            }
            case LINKED: {
                if (this.func_145830_o() && this.func_145831_w().field_72995_K) {
                    return this.syncedYaw;
                }
                Vec3d dir = this.getDirectionToTransmitter();
                return (float)Math.toDegrees(MathHelper.func_181159_b((double)dir.field_72450_a, (double)dir.field_72449_c));
            }
        }
        return 0.0f;
    }

    public float getPitch(float partialTicks) {
        switch (this.getCurrentState()) {
            case ERROR: {
                return (MathHelper.func_76126_a((float)(((float)this.field_145850_b.func_82737_E() + partialTicks) / 20.0f)) + 1.0f) / 2.0f * 90.0f - 20.0f;
            }
            case LINKED: {
                if (this.func_145830_o() && this.func_145831_w().field_72995_K) {
                    return this.syncedPitch;
                }
                Vec3d dir = this.getDirectionToTransmitter();
                Vec3d xz = new Vec3d(dir.field_72450_a, 0.0, dir.field_72449_c);
                double xzLength = xz.func_72433_c();
                return (float)(-Math.toDegrees(MathHelper.func_181159_b((double)dir.field_72448_b, (double)xzLength)));
            }
        }
        return 20.0f;
    }

    public Vec3d getFacing(float partialTicks) {
        switch (this.getCurrentState()) {
            case ERROR: {
                float yr = (float)Math.toRadians(this.getYaw(partialTicks));
                float pr = (float)Math.toRadians(this.getPitch(partialTicks));
                return new Vec3d((double)(-(MathHelper.func_76126_a((float)yr) * MathHelper.func_76134_b((float)pr))), (double)MathHelper.func_76126_a((float)pr), (double)(-(MathHelper.func_76134_b((float)yr) * MathHelper.func_76134_b((float)pr))));
            }
            case LINKED: {
                return this.getDirectionToTransmitter();
            }
        }
        return new Vec3d(0.0, 0.265, -0.735);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.func_174877_v().func_177958_n());
        tag.func_74768_a("y", this.func_174877_v().func_177956_o());
        tag.func_74768_a("z", this.func_174877_v().func_177952_p());
        tag.func_74776_a("Yaw", this.getYaw(0.0f));
        tag.func_74776_a("Pitch", this.getPitch(0.0f));
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.syncedYaw = pkt.func_148857_g().func_74760_g("Yaw");
        this.syncedPitch = pkt.func_148857_g().func_74760_g("Pitch");
    }

    public boolean hasTransmitter() {
        return this.getTransmitter() != null;
    }

    public CoPoWorldData.Transmitter getTransmitter() {
        CoPoWorldData.Transmitter t;
        if (!this.func_145830_o()) {
            return null;
        }
        if (this.transmitter == null) {
            return null;
        }
        if (this.transmitterCache != null && this.transmitterCache.isValid()) {
            return this.transmitterCache;
        }
        if (this.hasController() && !this.getController().isCheckingInfiniteLoop()) {
            this.getController().checkInfiniteLoop();
        }
        if ((t = CoPo.getDataFor(this.func_145831_w()).getTransmitterById(this.transmitter)) == null || t.position.func_177957_d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) > t.range * t.range) {
            return null;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
        this.transmitterCache = t;
        return t;
    }

    public void setTransmitter(UUID transmitter) {
        this.transmitter = transmitter;
        this.transmitterCache = null;
    }

    private Vec3d getDirectionToTransmitter() {
        if (!this.hasTransmitter()) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        BlockPos sub = this.func_174877_v().func_177973_b((Vec3i)this.getTransmitter().position);
        return new Vec3d((Vec3i)sub).func_72432_b();
    }

    @Override
    protected BlockWirelessEndpoint.State getCurrentState() {
        IBlockState state;
        if (this.func_145830_o() && this.func_145831_w().field_72995_K && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() == CoPo.wireless_endpoint) {
            return (BlockWirelessEndpoint.State)((Object)state.func_177229_b(BlockWirelessEndpoint.state));
        }
        return this.hasTransmitter() ? BlockWirelessEndpoint.State.LINKED : BlockWirelessEndpoint.State.ERROR;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("TransmitterUUIDMost", this.transmitter.getMostSignificantBits());
        compound.func_74772_a("TransmitterUUIDLeast", this.transmitter.getLeastSignificantBits());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setTransmitter(new UUID(compound.func_74763_f("TransmitterUUIDMost"), compound.func_74763_f("TransmitterUUIDLeast")));
    }

    public TileEntityController getTransmitterController() {
        if (!this.hasTransmitter()) {
            return null;
        }
        CoPoWorldData.Transmitter t = this.getTransmitter();
        TileEntity te = this.func_145831_w().func_175625_s(t.position);
        if (te != null && te instanceof TileEntityWirelessTransmitter) {
            return ((TileEntityWirelessTransmitter)te).getController();
        }
        return null;
    }

    @Override
    public int getEnergyConsumedPerTick() {
        return CoPo.inst.receiverRfUsage;
    }
}

