/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.base.Enums;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityInterface
extends TileEntityNetworkMember
implements IInventory,
ISidedInventory,
ITickable {
    private InventoryBasic inv = new InventoryBasic("container.interface", false, 18);
    private ItemStack[] prototypes = new ItemStack[9];
    private FaceMode[] modes = new FaceMode[6];

    public FaceMode getModeForFace(EnumFacing face) {
        if (face == null) {
            return null;
        }
        FaceMode mode = this.modes[face.ordinal()];
        if (mode == null) {
            this.modes[face.ordinal()] = FaceMode.PASSIVE;
            mode = FaceMode.PASSIVE;
            this.func_70296_d();
        }
        return mode;
    }

    public void setModeForFace(EnumFacing face, FaceMode mode) {
        if (face == null) {
            return;
        }
        this.modes[face.ordinal()] = mode;
        this.func_70296_d();
    }

    public ItemStack getOutputPrototype(int i) {
        return this.prototypes[i];
    }

    public void setOutputPrototype(int i, ItemStack prototype) {
        this.prototypes[i] = prototype;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeFacesToNBT(compound);
        NBTTagList inv = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is == null) continue;
            NBTTagCompound nbt = is.func_77955_b(new NBTTagCompound());
            nbt.func_74768_a("Slot", i);
            inv.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Buffer", (NBTBase)inv);
        NBTTagList proto = new NBTTagList();
        for (int i = 0; i < this.prototypes.length; ++i) {
            ItemStack is = this.prototypes[i];
            if (is == null) continue;
            NBTTagCompound nbt = is.func_77955_b(new NBTTagCompound());
            nbt.func_74768_a("Slot", i);
            nbt.func_82580_o("Count");
            proto.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Prototypes", (NBTBase)proto);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readFacesFromNBT(compound);
        NBTTagList inv = compound.func_150295_c("Buffer", 10);
        for (int i = 0; i < inv.func_74745_c(); ++i) {
            NBTTagCompound nbt = inv.func_150305_b(i);
            this.func_70299_a(nbt.func_74762_e("Slot"), ItemStack.func_77949_a((NBTTagCompound)nbt));
        }
        NBTTagList proto = compound.func_150295_c("Prototypes", 10);
        for (int i = 0; i < proto.func_74745_c(); ++i) {
            NBTTagCompound nbt = proto.func_150305_b(i);
            nbt.func_74768_a("Count", 1);
            this.prototypes[nbt.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        this.writeFacesToNBT(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readFacesFromNBT(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    private void writeFacesToNBT(NBTTagCompound nbt) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            nbt.func_74778_a("Mode-" + face.func_176610_l(), this.getModeForFace(face).name());
        }
    }

    private void readFacesFromNBT(NBTTagCompound nbt) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.setModeForFace(face, (FaceMode)((Object)Enums.getIfPresent(FaceMode.class, (String)nbt.func_74779_i("Mode-" + face.func_176610_l())).or((Object)FaceMode.PASSIVE)));
        }
    }

    public void func_73660_a() {
        if (this.hasController() && this.func_145830_o() && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 16L == 0L) {
            int i;
            TileEntityController controller = this.getController();
            if (!controller.isPowered() || controller.booting || controller.error) {
                return;
            }
            for (i = 0; i <= 8; ++i) {
                ItemStack stack = this.inv.func_70301_a(i);
                if (stack == null) continue;
                this.inv.func_70299_a(i, controller.addItemToNetwork(stack));
            }
            for (i = 9; i <= 17; ++i) {
                int needed;
                ItemStack prototype = this.prototypes[i - 9];
                if (prototype == null) continue;
                ItemStack cur = this.inv.func_70301_a(i);
                if (cur == null) {
                    needed = prototype.func_77976_d();
                    cur = prototype.func_77946_l();
                    cur.field_77994_a = 0;
                } else {
                    if (!ItemStack.func_179545_c((ItemStack)cur, (ItemStack)prototype) || !ItemStack.func_77970_a((ItemStack)cur, (ItemStack)prototype)) continue;
                    needed = prototype.func_77976_d() - cur.field_77994_a;
                }
                if (needed <= 0) continue;
                ItemStack stack = controller.removeItemsFromNetwork(prototype, needed, false);
                if (stack != null) {
                    cur.field_77994_a += stack.field_77994_a;
                }
                if (cur.field_77994_a <= 0) {
                    this.inv.func_70299_a(i, null);
                    continue;
                }
                this.inv.func_70299_a(i, cur);
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                TileEntity other;
                FaceMode mode = this.getModeForFace(face);
                if (mode == FaceMode.DISABLED || mode == FaceMode.PASSIVE || !((other = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face))) instanceof IInventory)) continue;
                if (other instanceof ISidedInventory) {
                    ISidedInventory sided = (ISidedInventory)other;
                    int[] slots = sided.func_180463_a(face.func_176734_d());
                    if (slots == null || slots.length <= 0) continue;
                    if (mode == FaceMode.ACTIVE_PUSH) {
                        for (int i2 = 9; i2 < 18; ++i2) {
                            int slot;
                            ItemStack content = this.func_70301_a(i2);
                            if (content == null || (slot = TileEntityInterface.findSlot((IInventory)sided, content, slots)) == -1 || !sided.func_180462_a(slot, content, face.func_176734_d())) continue;
                            TileEntityInterface.transfer(this, i2, (IInventory)sided, slot);
                        }
                        continue;
                    }
                    if (mode != FaceMode.ACTIVE_PULL) continue;
                    for (int s : slots) {
                        int slot;
                        ItemStack content = sided.func_70301_a(s);
                        if (content == null || (slot = TileEntityInterface.findSlot(this, content, 0, 9)) == -1 || !sided.func_180461_b(s, content, face.func_176734_d())) continue;
                        TileEntityInterface.transfer((IInventory)sided, s, this, slot);
                    }
                    continue;
                }
                if (!(other instanceof IInventory)) continue;
                IInventory inv = (IInventory)other;
                if (mode == FaceMode.ACTIVE_PUSH) {
                    for (int i3 = 9; i3 < 18; ++i3) {
                        int slot;
                        ItemStack content = this.func_70301_a(i3);
                        if (content == null || (slot = TileEntityInterface.findSlot(inv, content, 0, inv.func_70302_i_())) == -1) continue;
                        TileEntityInterface.transfer(this, i3, inv, slot);
                    }
                    continue;
                }
                if (mode != FaceMode.ACTIVE_PULL) continue;
                for (int s = 0; s < inv.func_70302_i_(); ++s) {
                    int slot;
                    ItemStack content = inv.func_70301_a(s);
                    if (content == null || (slot = TileEntityInterface.findSlot(this, content, 0, 9)) == -1) continue;
                    TileEntityInterface.transfer(inv, s, this, slot);
                }
            }
        }
    }

    private static void transfer(IInventory fromInv, int fromSlot, IInventory toInv, int toSlot) {
        ItemStack fromStack = fromInv.func_70301_a(fromSlot);
        if (fromStack == null) {
            return;
        }
        int toTake = Math.min(fromStack.field_77994_a, Math.min(toInv.func_70297_j_(), fromStack.func_77976_d()));
        ItemStack toStack = toInv.func_70301_a(toSlot);
        if (toStack == null) {
            toStack = fromStack.func_77979_a(toTake);
        } else {
            toStack.field_77994_a += toTake;
            fromStack.field_77994_a -= toTake;
        }
        if (fromStack.field_77994_a <= 0) {
            fromInv.func_70299_a(fromSlot, null);
        }
        toInv.func_70299_a(toSlot, toStack);
    }

    private static int findSlot(IInventory inv, ItemStack a, int start, int end) {
        for (int i = start; i < end; ++i) {
            ItemStack b = inv.func_70301_a(i);
            if (b == null) {
                return i;
            }
            if (b.field_77994_a >= b.func_77976_d() || b.field_77994_a >= inv.func_70297_j_() || !ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) || !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) continue;
            return i;
        }
        return -1;
    }

    private static int findSlot(IInventory inv, ItemStack a, int[] slots) {
        for (int i : slots) {
            ItemStack b = inv.func_70301_a(i);
            if (b == null) {
                return i;
            }
            if (b.field_77994_a >= b.func_77976_d() || b.field_77994_a >= inv.func_70297_j_() || !ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) || !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getEnergyConsumedPerTick() {
        return CoPo.inst.interfaceRfUsage;
    }

    public String func_70005_c_() {
        return "container.correlatedpotentialistics.interface";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.getModeForFace(side) == FaceMode.DISABLED) {
            return new int[0];
        }
        if (this.getModeForFace(side) == FaceMode.ACTIVE_PULL) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        }
        if (this.getModeForFace(side) == FaceMode.ACTIVE_PUSH) {
            return new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.getModeForFace(direction).canInsert() && index >= 0 && index <= 8;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return this.getModeForFace(direction).canExtract() && index >= 9 && index <= 17;
    }

    public int func_70302_i_() {
        return 18;
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < 9;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public static enum FaceMode implements IStringSerializable
    {
        PASSIVE,
        ACTIVE_PULL,
        ACTIVE_PUSH,
        DISABLED;


        public boolean canInsert() {
            return this == PASSIVE || this == ACTIVE_PULL;
        }

        public boolean canExtract() {
            return this == PASSIVE || this == ACTIVE_PUSH;
        }

        public String func_176610_l() {
            switch (this) {
                case ACTIVE_PULL: {
                    return "pull";
                }
                case ACTIVE_PUSH: {
                    return "push";
                }
                case PASSIVE: {
                    return "none";
                }
                case DISABLED: {
                    return "disabled";
                }
            }
            return null;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

