/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.base.Predicates;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockDriveBay;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class TileEntityDriveBay
extends TileEntityNetworkMember
implements ITickable {
    private ItemStack[] drives = new ItemStack[8];
    private int consumedPerTick;

    public TileEntityDriveBay() {
        this.consumedPerTick = CoPo.inst.driveBayRfUsage;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeDrives(compound, 0, 1, 2, 3, 4, 5, 6, 7);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readDrives(compound);
    }

    @Override
    public int getEnergyConsumedPerTick() {
        return this.consumedPerTick;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        this.writeDrives(nbt, 0, 1, 2, 3, 4, 5, 6, 7);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readDrives(pkt.func_148857_g());
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            boolean lit;
            for (int i = 0; i < 8; ++i) {
                ItemStack is = this.drives[i];
                if (is == null || !((Boolean)ItemStacks.getBoolean(is, "Dirty").or((Object)false)).booleanValue()) continue;
                is.func_77978_p().func_82580_o("Dirty");
                this.func_70296_d();
                this.setDriveInSlot(i, is);
            }
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == CoPo.drive_bay && (lit = this.hasController() && this.getController().isPowered()) != (Boolean)state.func_177229_b((IProperty)BlockDriveBay.lit)) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockDriveBay.lit, (Comparable)Boolean.valueOf(lit)));
            }
        }
    }

    private void writeDrives(NBTTagCompound nbt, int ... slots) {
        for (int i : slots) {
            this.writeDrive(nbt, i);
        }
    }

    private void writeDrive(NBTTagCompound nbt, int slot) {
        NBTTagCompound drive = new NBTTagCompound();
        if (this.drives[slot] != null) {
            this.drives[slot].func_77955_b(drive);
        }
        nbt.func_74782_a("Drive" + slot, (NBTBase)drive);
    }

    private void readDrives(NBTTagCompound nbt) {
        for (int i = 0; i < this.drives.length; ++i) {
            if (!nbt.func_74764_b("Drive" + i)) continue;
            NBTTagCompound drive = nbt.func_74775_l("Drive" + i);
            if (drive.func_82582_d()) {
                this.drives[i] = null;
                continue;
            }
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)drive);
            if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
                ItemStacks.ensureHasTag(is);
                is.func_77982_d((NBTTagCompound)is.func_77978_p().func_74737_b());
                is.func_77978_p().func_74757_a("Dirty", true);
            }
            this.drives[i] = is;
        }
        this.onDriveChange();
    }

    public void setDriveInSlot(int slot, ItemStack drive) {
        this.drives[slot] = drive;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeDrive(nbt, slot);
            WorldServer ws = (WorldServer)this.field_145850_b;
            Chunk c = this.field_145850_b.func_175726_f(this.func_174877_v());
            SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), nbt);
            for (EntityPlayerMP player : this.field_145850_b.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                if (!ws.func_184164_w().func_72694_a(player, c.field_76635_g, c.field_76647_h)) continue;
                player.field_71135_a.func_147359_a((Packet)packet);
            }
            this.onDriveChange();
        }
    }

    private void onDriveChange() {
        int old = this.consumedPerTick;
        this.consumedPerTick = CoPo.inst.driveBayRfUsage;
        for (ItemStack is : this.drives) {
            if (is == null || !(is.func_77973_b() instanceof ItemDrive)) continue;
            this.consumedPerTick += ((ItemDrive)is.func_77973_b()).getRFConsumptionRate(is);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.hasController()) {
            this.getController().updateConsumptionRate(this.consumedPerTick - old);
            this.getController().updateDrivesCache();
        }
    }

    public ItemStack getDriveInSlot(int slot) {
        return this.drives[slot];
    }

    public boolean hasDriveInSlot(int slot) {
        return this.drives[slot] != null;
    }
}

