/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.helper.DriveComparator;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityController
extends TileEntityNetworkMember
implements IEnergyReceiver,
ITickable {
    public static final int POWER_CAP = 640;
    private EnergyStorage energy = new EnergyStorage(64000, 641);
    public boolean error = false;
    public boolean booting = true;
    public String errorReason;
    private int consumedPerTick = 32;
    public int bootTicks = 0;
    private int networkMembers = 0;
    private transient Set<BlockPos> networkMemberLocations = Sets.newHashSet();
    private transient List<TileEntityInterface> interfaces = Lists.newArrayList();
    private transient List<TileEntityWirelessReceiver> receivers = Lists.newArrayList();
    private transient List<TileEntityDriveBay> driveBays = Lists.newArrayList();
    private transient List<ItemStack> drives = Lists.newArrayList();
    public int changeId = 0;
    private boolean checkingInfiniteLoop = false;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.energy.writeToNBT(compound);
        return compound;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.bootTicks > 100 && this.booting) {
            this.booting = false;
            this.scanNetwork();
        }
        if (this.isPowered()) {
            this.energy.modifyEnergyStored(-this.getEnergyConsumedPerTick());
            ++this.bootTicks;
        } else {
            this.energy.setEnergyStored(0);
        }
        this.updateState();
    }

    @Override
    public int getEnergyConsumedPerTick() {
        return this.consumedPerTick;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int rtrn = this.energy.receiveEnergy(maxReceive, simulate);
        this.updateState();
        return rtrn;
    }

    @Override
    public boolean hasController() {
        return true;
    }

    @Override
    public TileEntityController getController() {
        return this;
    }

    @Override
    public void setController(TileEntityController controller) {
    }

    public void scanNetwork() {
        TileEntity te2;
        if (!this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.booting) {
            return;
        }
        HashSet seen = Sets.newHashSet();
        ArrayList members = Lists.newArrayList();
        ArrayList queue = Lists.newArrayList((Object[])new BlockPos[]{this.func_174877_v()});
        boolean foundOtherController = false;
        int consumedPerTick = CoPo.inst.controllerRfUsage;
        for (BlockPos pos : this.networkMemberLocations) {
            te2 = this.field_145850_b.func_175625_s(pos);
            if (!(te2 instanceof TileEntityNetworkMember)) continue;
            ((TileEntityNetworkMember)te2).setController(null);
        }
        this.networkMembers = 0;
        this.networkMemberLocations.clear();
        this.driveBays.clear();
        this.receivers.clear();
        this.interfaces.clear();
        int itr = 0;
        while (!queue.isEmpty()) {
            BlockPos pos;
            if (itr > 100) {
                this.error = true;
                this.errorReason = "network_too_big";
                consumedPerTick = 640;
                return;
            }
            pos = (BlockPos)queue.remove(0);
            seen.add(pos);
            te2 = this.func_145831_w().func_175625_s(pos);
            if (te2 instanceof TileEntityNetworkMember) {
                for (EnumFacing ef : EnumFacing.field_82609_l) {
                    BlockPos p = pos.func_177972_a(ef);
                    if (seen.contains(p)) continue;
                    if (this.field_145850_b.func_175625_s(p) == null) {
                        seen.add(p);
                        continue;
                    }
                    queue.add(p);
                }
                if (te2 != this) {
                    if (te2 instanceof TileEntityController) {
                        this.error = true;
                        ((TileEntityController)te2).error = true;
                        CoPo.log.debug("Found other controller");
                        foundOtherController = true;
                    }
                    if (!members.contains(te2)) {
                        members.add((TileEntityNetworkMember)te2);
                        if (te2 instanceof TileEntityDriveBay) {
                            this.driveBays.add((TileEntityDriveBay)te2);
                        } else if (te2 instanceof TileEntityInterface) {
                            this.interfaces.add((TileEntityInterface)te2);
                        } else if (te2 instanceof TileEntityWirelessReceiver) {
                            this.receivers.add((TileEntityWirelessReceiver)te2);
                        }
                        this.networkMemberLocations.add(pos);
                        consumedPerTick += ((TileEntityNetworkMember)te2).getEnergyConsumedPerTick();
                    }
                }
            }
            ++itr;
        }
        if (foundOtherController) {
            this.error = true;
            this.errorReason = "multiple_controllers";
            consumedPerTick = 4;
        } else {
            this.error = false;
            this.errorReason = null;
        }
        this.checkInfiniteLoop();
        for (TileEntity te2 : members) {
            te2.setController(this);
        }
        this.networkMembers = itr;
        if (consumedPerTick > 640) {
            this.error = true;
            this.errorReason = "too_much_power";
        }
        this.consumedPerTick = consumedPerTick;
        this.updateDrivesCache();
        CoPo.log.debug("Found " + members.size() + " network members");
    }

    public void checkInfiniteLoop() {
        this.checkingInfiniteLoop = true;
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null || !cont.isLinkedTo(this)) continue;
            this.error = true;
            this.errorReason = "infinite_loop";
            this.receivers.clear();
            this.checkingInfiniteLoop = false;
            return;
        }
        if (this.error && this.errorReason.equals("infinite_loop")) {
            this.error = false;
            this.errorReason = null;
        }
        this.checkingInfiniteLoop = false;
    }

    public boolean isCheckingInfiniteLoop() {
        return this.checkingInfiniteLoop;
    }

    public boolean isLinkedTo(TileEntityController tec) {
        if (((Object)((Object)tec)).equals((Object)this)) {
            return true;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null || !cont.isLinkedTo(tec)) continue;
            return true;
        }
        return false;
    }

    private void updateState() {
        BlockController.State nw;
        if (!this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockController.State old = (BlockController.State)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockController.state));
        if (this.isPowered()) {
            if (old == BlockController.State.OFF) {
                this.booting = true;
                this.bootTicks = -200;
            }
            nw = this.booting ? BlockController.State.BOOTING : (this.error ? BlockController.State.ERROR : BlockController.State.POWERED);
        } else {
            nw = BlockController.State.OFF;
        }
        if (old != nw) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockController.state, (Comparable)((Object)nw)));
        }
    }

    public boolean isPowered() {
        return this.energy.getEnergyStored() >= this.getEnergyConsumedPerTick();
    }

    public void updateDrivesCache() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            return;
        }
        this.drives.clear();
        for (TileEntityDriveBay tedb : this.driveBays) {
            if (tedb.func_145837_r()) continue;
            for (int i = 0; i < 8; ++i) {
                if (!tedb.hasDriveInSlot(i)) continue;
                this.drives.add(tedb.getDriveInSlot(i));
            }
        }
        Collections.sort(this.drives, new DriveComparator());
    }

    public void updateConsumptionRate(int change) {
        this.consumedPerTick += change;
        if (this.consumedPerTick > 640) {
            this.error = true;
            this.errorReason = "too_much_power";
        } else if (this.error && "too_much_power".equals(this.errorReason)) {
            this.error = false;
            this.errorReason = null;
        }
    }

    public ItemStack addItemToNetwork(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            itemDrive.addItem(drive, stack);
            if (stack.field_77994_a > 0) continue;
            break;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont != null) {
                cont.addItemToNetwork(stack);
            }
            if (stack.field_77994_a > 0) continue;
            break;
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    public ItemStack removeItemsFromNetwork(ItemStack prototype, int amount, boolean checkInterfaces) {
        if (prototype == null) {
            return null;
        }
        ItemStack stack = prototype.func_77946_l();
        stack.field_77994_a = 0;
        if (checkInterfaces) {
            block0: for (TileEntityInterface in : this.interfaces) {
                for (int i = 9; i <= 17; ++i) {
                    ItemStack is = in.func_70301_a(i);
                    if (is == null || !ItemStack.func_179545_c((ItemStack)is, (ItemStack)prototype) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)prototype)) continue;
                    int amountWanted = amount - stack.field_77994_a;
                    int amountTaken = Math.min(is.field_77994_a, amountWanted);
                    is.field_77994_a -= amountTaken;
                    stack.field_77994_a += amountTaken;
                    if (is.field_77994_a <= 0) {
                        in.func_70299_a(i, null);
                    }
                    if (stack.field_77994_a >= amount) continue block0;
                }
            }
        }
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            int amountWanted = amount - stack.field_77994_a;
            itemDrive.removeItems(drive, stack, amountWanted);
            if (stack.field_77994_a < amount) continue;
            break;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            ItemStack remote;
            TileEntityController cont = r.getTransmitterController();
            if (cont != null && (remote = cont.removeItemsFromNetwork(prototype, amount - stack.field_77994_a, checkInterfaces)) != null) {
                stack.field_77994_a += remote.field_77994_a;
            }
            if (stack.field_77994_a < amount) continue;
            break;
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    public List<ItemStack> getTypes() {
        ArrayList li = Lists.newArrayList();
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            li.addAll(((ItemDrive)drive.func_77973_b()).getTypes(drive));
        }
        for (TileEntityInterface in : this.interfaces) {
            for (int i = 9; i <= 17; ++i) {
                ItemStack ifaceStack = in.func_70301_a(i);
                if (ifaceStack == null) continue;
                boolean added = false;
                for (ItemStack cur : li) {
                    if (!ItemStack.func_179545_c((ItemStack)ifaceStack, (ItemStack)cur) || !ItemStack.func_77970_a((ItemStack)ifaceStack, (ItemStack)cur)) continue;
                    cur.field_77994_a += ifaceStack.field_77994_a;
                    added = true;
                    break;
                }
                if (added) continue;
                li.add(ifaceStack.func_77946_l());
            }
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null) continue;
            li.addAll(cont.getTypes());
        }
        return li;
    }

    public void onNetworkPatched(TileEntityNetworkMember tenm) {
        if (this.networkMembers == 0) {
            return;
        }
        if (tenm instanceof TileEntityDriveBay) {
            if (!this.driveBays.contains((Object)tenm)) {
                this.driveBays.add((TileEntityDriveBay)tenm);
                this.updateDrivesCache();
                ++this.changeId;
            }
        } else if (tenm instanceof TileEntityInterface) {
            if (!this.interfaces.contains((Object)tenm)) {
                this.interfaces.add((TileEntityInterface)tenm);
                ++this.changeId;
            }
        } else if (tenm instanceof TileEntityWirelessReceiver && !this.receivers.contains((Object)tenm)) {
            this.receivers.add((TileEntityWirelessReceiver)tenm);
            this.checkInfiniteLoop();
            ++this.changeId;
        }
        if (this.networkMemberLocations.add(tenm.func_174877_v())) {
            ++this.networkMembers;
            if (this.networkMembers > 100) {
                this.error = true;
                this.errorReason = "network_too_big";
                this.consumedPerTick = 640;
            }
        }
    }

    public boolean knowsOfMemberAt(BlockPos pos) {
        return this.networkMemberLocations.contains(pos);
    }
}

